package jp.co.sra.jun.goodies.track;

import java.awt.Dimension;

import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.button.JunButtonViewSwing;
import jp.co.sra.jun.goodies.button.JunButtonWithMenuViewSwing;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunTrackerViewSwing class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/11/24 (by MATSUDA Ryouichi)
 *  @updated   1999/12/10 (by MATSUDA Ryouichi)
 *  @updated   2002/10/30 (by MATSUDA Ryouichi)
 *  @updated   2003/03/24 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2006/02/23 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTrackerViewSwing.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunTrackerViewSwing extends JunAbstractViewJPanel implements JunTrackerView {

	protected JunTrackSliderViewSwing sliderView;
	protected JunButtonViewSwing playButtonView;
	protected JunButtonViewSwing loopButtonView;
	protected JunButtonViewSwing previousButtonView;
	protected JunButtonViewSwing nextButtonView;
	protected JunButtonViewSwing firstButtonView;
	protected JunButtonViewSwing lastButtonView;
	protected JunButtonViewSwing firstMarkerButtonView;
	protected JunButtonViewSwing lastMarkerButtonView;
	protected JunButtonWithMenuViewSwing speakerButtonView;

	/**
	 * Create a new instance of JunTrackerViewSwing and initialize it.
	 * 
	 * @param aTrackerModel jp.co.sra.jun.goodies.track.JunTrakcerModel
	 * @category Instance creation
	 */
	public JunTrackerViewSwing(JunTrackerModel aTrackerModel) {
		super(aTrackerModel);
	}

	/**
	 * Build this component.
	 * 
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.sliderView(), WindowSpecLayout.Position(0f, 39, 1f, -19, 1f, -39, 1f, -1));
		this.add(this.playButtonView(), WindowSpecLayout.Position(0f, 1, 1f, -19, 0f, 19, 1f, -1));
		this.add(this.loopButtonView(), WindowSpecLayout.Position(0f, 20, 1f, -19, 0f, 38, 1f, -1));
		this.add(this.previousButtonView(), WindowSpecLayout.Position(1f, -38, 1f, -19, 1f, -20, 1f, -1));
		this.add(this.nextButtonView(), WindowSpecLayout.Position(1f, -19, 1f, -19, 1f, -1, 1f, -1));
		this.setPreferredSize(new Dimension(200, 100));
	}

	/**
	 * Stop thread before component is removed.
	 * 
	 * @category initialize-release
	 */
	public void removeNotify() {
		this.getTrackerModel().end();
		super.removeNotify();
	}

	/**
	 * Answer my model as JunTrackerModel.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunTrackerModel
	 * @category model accessing
	 */
	public JunTrackerModel getTrackerModel() {
		return (JunTrackerModel) this.model();
	}

	/**
	 * model property accessing
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunTrackerModel
	 * @deprecated since Jun379, use getTrackerModel()
	 * @category model accessing
	 */
	public JunTrackerModel getModel() {
		return (JunTrackerModel) this.model();
	}

	/**
	 * model property accessing
	 * 
	 * @param aModel jp.co.sra.jun.goodies.track.JunTrackerModel
	 * @deprecated since Jun379
	 * @category model accessing
	 */
	public void setModel(JunTrackerModel aModel) {
		model_(aModel);
	}

	/**
	 * Answer a default model.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 * @category model accessing
	 */
	protected StModel defaultModel() {
		return new JunTrackerModel();
	}

	/**
	 * Answer my slider view.
	 *
	 * @return jp.co.sra.jun.goodies.track.JunTrackSliderViewSwing
	 * @category user interface
	 */
	public JunTrackSliderViewSwing sliderView() {
		if (sliderView == null) {
			sliderView = new JunTrackSliderViewSwing(this.getTrackerModel());
		}
		return sliderView;
	}

	/**
	 * Answer my play button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	public JunButtonViewSwing playButtonView() {
		if (playButtonView == null) {
			playButtonView = new JunButtonViewSwing(this.getTrackerModel().playButton());
		}
		return playButtonView;
	}

	/**
	 * Answer my loop button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	public JunButtonViewSwing loopButtonView() {
		if (loopButtonView == null) {
			loopButtonView = new JunButtonViewSwing(this.getTrackerModel().loopButton());
		}
		return loopButtonView;
	}

	/**
	 * Answer my previous button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	public JunButtonViewSwing previousButtonView() {
		if (previousButtonView == null) {
			previousButtonView = new JunButtonViewSwing(this.getTrackerModel().previousButton());
		}
		return previousButtonView;
	}

	/**
	 * Answer my next button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	public JunButtonViewSwing nextButtonView() {
		if (nextButtonView == null) {
			nextButtonView = new JunButtonViewSwing(this.getTrackerModel().nextButton());
		}
		return nextButtonView;
	}

	/**
	 * Answer my first button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	public JunButtonViewSwing firstButtonView() {
		if (firstButtonView == null) {
			firstButtonView = new JunButtonViewSwing(this.getTrackerModel().firstButton());
		}
		return firstButtonView;
	}

	/**
	 * Answer my last button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	public JunButtonViewSwing lastButtonView() {
		if (lastButtonView == null) {
			lastButtonView = new JunButtonViewSwing(this.getTrackerModel().lastButton());
		}
		return lastButtonView;
	}

	/**
	 * Answer my first marker button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	public JunButtonViewSwing firstMarkerButtonView() {
		if (firstMarkerButtonView == null) {
			firstMarkerButtonView = new JunButtonViewSwing(this.getTrackerModel().firstMarkerButton());
		}
		return firstMarkerButtonView;
	}

	/**
	 * Answer my last marker button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	public JunButtonViewSwing lastMarkerButtonView() {
		if (lastMarkerButtonView == null) {
			lastMarkerButtonView = new JunButtonViewSwing(this.getTrackerModel().lastMarkerButton());
		}
		return lastMarkerButtonView;
	}

	/**
	 * Answer my speaker button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonWithMenuViewSwing
	 * @category user interface
	 */
	public JunButtonWithMenuViewSwing speakerButtonView() {
		if (speakerButtonView == null) {
			speakerButtonView = new JunButtonWithMenuViewSwing(this.getTrackerModel().speakerButton());
		}
		return speakerButtonView;
	}

}
