package jp.co.sra.jun.goodies.track;

import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.button.JunButtonViewAwt;
import jp.co.sra.jun.goodies.button.JunButtonWithMenuViewAwt;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunTrackerViewAwt class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/11/24 (by MATSUDA Ryouichi)
 *  @updated   1999/12/10 (by MATSUDA Ryouichi)
 *  @updated   2002/10/30 (by MATSUDA Ryouichi)
 *  @updated   2003/03/24 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2006/02/23 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTrackerViewAwt.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunTrackerViewAwt extends JunAbstractViewPanel implements JunTrackerView {

	protected JunTrackSliderViewAwt sliderView;
	protected JunButtonViewAwt playButtonView;
	protected JunButtonViewAwt loopButtonView;
	protected JunButtonViewAwt previousButtonView;
	protected JunButtonViewAwt nextButtonView;
	protected JunButtonViewAwt firstButtonView;
	protected JunButtonViewAwt lastButtonView;
	protected JunButtonViewAwt firstMarkerButtonView;
	protected JunButtonViewAwt lastMarkerButtonView;
	protected JunButtonWithMenuViewAwt speakerButtonView;

	/**
	 * Create a new instance of JunTrackerViewAwt and initialize it.
	 * 
	 * @param aTrackerModel jp.co.sra.jun.goodies.track.JunTrakcerModel
	 * @category Instance creation
	 */
	public JunTrackerViewAwt(JunTrackerModel aTrackerModel) {
		super(aTrackerModel);
	}

	/**
	 * Build this component.
	 * 
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.sliderView(), WindowSpecLayout.Position(0f, 39, 1f, -19, 1f, -39, 1f, -1));
		this.add(this.playButtonView(), WindowSpecLayout.Position(0f, 1, 1f, -19, 0f, 19, 1f, -1));
		this.add(this.loopButtonView(), WindowSpecLayout.Position(0f, 20, 1f, -19, 0f, 38, 1f, -1));
		this.add(this.previousButtonView(), WindowSpecLayout.Position(1f, -38, 1f, -19, 1f, -20, 1f, -1));
		this.add(this.nextButtonView(), WindowSpecLayout.Position(1f, -19, 1f, -19, 1f, -1, 1f, -1));
		this.setSize(200, 100);
	}

	/**
	 * Stop thread before component is removed.
	 * 
	 * @category initialize-release
	 */
	public void removeNotify() {
		this.getTrackerModel().end();
		super.removeNotify();
	}

	/**
	 * Answer my model as JunTrackerModel.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunTrackerModel
	 * @category model accessing
	 */
	public JunTrackerModel getTrackerModel() {
		return (JunTrackerModel) this.model();
	}

	/**
	 * model property accessing
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunTrackerModel
	 * @deprecated since Jun379, use getTrackerModel()
	 * @category model accessing
	 */
	public JunTrackerModel getModel() {
		return (JunTrackerModel) this.model();
	}

	/**
	 * model property accessing
	 * 
	 * @param aModel jp.co.sra.jun.goodies.track.JunTrackerModel
	 * @deprecated since Jun379
	 * @category model accessing
	 */
	public void setModel(JunTrackerModel aModel) {
		model_(aModel);
	}

	/**
	 * Answer a default model.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 * @category model accessing
	 */
	protected StModel defaultModel() {
		return new JunTrackerModel();
	}

	/**
	 * Answer my slider view.
	 *
	 * @return jp.co.sra.jun.goodies.track.JunTrackSliderViewAwt
	 * @category user interface
	 */
	public JunTrackSliderViewAwt sliderView() {
		if (sliderView == null) {
			sliderView = new JunTrackSliderViewAwt(this.getTrackerModel());
		}
		return sliderView;
	}

	/**
	 * Answer my play button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt playButtonView() {
		if (playButtonView == null) {
			playButtonView = new JunButtonViewAwt(this.getTrackerModel().playButton());
		}
		return playButtonView;
	}

	/**
	 * Answer my loop button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt loopButtonView() {
		if (loopButtonView == null) {
			loopButtonView = new JunButtonViewAwt(this.getTrackerModel().loopButton());
		}
		return loopButtonView;
	}

	/**
	 * Answer my previous button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt previousButtonView() {
		if (previousButtonView == null) {
			previousButtonView = new JunButtonViewAwt(this.getTrackerModel().previousButton());
		}
		return previousButtonView;
	}

	/**
	 * Answer my next button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt nextButtonView() {
		if (nextButtonView == null) {
			nextButtonView = new JunButtonViewAwt(this.getTrackerModel().nextButton());
		}
		return nextButtonView;
	}

	/**
	 * Answer my first button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt firstButtonView() {
		if (firstButtonView == null) {
			firstButtonView = new JunButtonViewAwt(this.getTrackerModel().firstButton());
		}
		return firstButtonView;
	}

	/**
	 * Answer my last button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt lastButtonView() {
		if (lastButtonView == null) {
			lastButtonView = new JunButtonViewAwt(this.getTrackerModel().lastButton());
		}
		return lastButtonView;
	}

	/**
	 * Answer my first marker button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt firstMarkerButtonView() {
		if (firstMarkerButtonView == null) {
			firstMarkerButtonView = new JunButtonViewAwt(this.getTrackerModel().firstMarkerButton());
		}
		return firstMarkerButtonView;
	}

	/**
	 * Answer my last marker button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt lastMarkerButtonView() {
		if (lastMarkerButtonView == null) {
			lastMarkerButtonView = new JunButtonViewAwt(this.getTrackerModel().lastMarkerButton());
		}
		return lastMarkerButtonView;
	}

	/**
	 * Answer my speaker button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonWithMenuViewAwt
	 * @category user interface
	 */
	public JunButtonWithMenuViewAwt speakerButtonView() {
		if (speakerButtonView == null) {
			speakerButtonView = new JunButtonWithMenuViewAwt(this.getTrackerModel().speakerButton());
		}
		return speakerButtonView;
	}

}
