package jp.co.sra.jun.goodies.track;

import java.awt.Color;
import java.awt.Graphics;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunSimpleSliderView interface
 * 
 *  @author    Hoshi Takanori
 *  @created   2003/08/27 (by Hoshi Takanori)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSimpleSliderView.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public interface JunSimpleSliderView extends JunAbstractView {

	public static final Color Gray20 = new Color(51, 51, 51);
	public static final Color Gray70 = new Color(178, 178, 178);
	public static final Color Gray80 = new Color(204, 204, 204);
	public static final Color Gray90 = new Color(229, 229, 229);

	/**
	 * Display on the graphics.
	 * 
	 * @param graphicsContext
	 */
	public void displayOn_(Graphics graphicsContext);

	/**
	 * Display the slider on the graphics context.
	 *
	 * @param graphicsContext java.awt.Graphics
	 */
	public void displaySliderOn_(Graphics graphicsContext);

	/**
	 * Answer the current model as a JunSimpleSliderModel.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderModel
	 */
	public JunSimpleSliderModel getSimpleSliderModel();

	/**
	 * Set the new model value via view.
	 * 
	 * @param x
	 * @param y
	 */
	public void setModelValue_(int x, int y);

	/**
	 * Answer the current slider area.
	 * 
	 * @return StRectangle
	 */
	public StRectangle sliderArea();

	/**
	 * Answer the current slider rectangle.
	 * 
	 * @return StRectangle
	 */
	public StRectangle sliderRectangle();

}
