package jp.co.sra.jun.goodies.texteditor;

import java.awt.Button;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jp.co.sra.smalltalk.StSimpleDialogViewAwt;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunTextEditorDialogViewAwt class
 * 
 *  @author    m-asada
 *  @created   2005/05/11 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextEditorDialogViewAwt.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunTextEditorDialogViewAwt extends StSimpleDialogViewAwt implements JunTextEditorDialogView {
	protected JunTextEditorViewAwt textPropertiesView;
	protected Button acceptButton;
	protected Button cancelButton;

	/**
	 * Create a new instance of JunTextEditorDialogViewAwt and initialize it.
	 * 
	 * @param aTextEditorDialog jp.co.sra.jun.goodies.texteditor.JunTextEditorDialog
	 * @category Instance creation
	 */
	public JunTextEditorDialogViewAwt(JunTextEditorDialog aTextEditorDialog) {
		super(aTextEditorDialog);
	}

	/**
	 * Answer my model as JunTextEditorDialog.
	 * 
	 * @return jp.co.sra.jun.goodies.texteditor.JunTextEditorDialog
	 * @see jp.co.sra.jun.goodies.texteditoreditor.JunTextEditorDialogView#getTextEditorDialog()
	 * @category model accessing
	 */
	public JunTextEditorDialog getTextEditorDialog() {
		return (JunTextEditorDialog) this.model();
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		textPropertiesView = null;
		acceptButton = null;
		cancelButton = null;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.textPropertiesView()._onBorderedPanel(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, -1, 1f, -30));
		this.add(this.acceptButton(), WindowSpecLayout.Position(0.5f, -86, 1f, -27, 0.5f, -2, 1f, -1));
		this.add(this.cancelButton(), WindowSpecLayout.Position(0.5f, 2, 1f, -27, 0.5f, 86, 1f, -1));
		this.setSize(300, 200);

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer the receiver's text properties view.
	 * 
	 * @return jp.co.sra.jun.goodies.texteditor.JunTextEditorViewAwt
	 * @category interface opening
	 */
	protected JunTextEditorViewAwt textPropertiesView() {
		if (textPropertiesView == null) {
			textPropertiesView = new JunTextEditorViewAwt(this.getTextEditorDialog().textPropertiesModel());
		}
		return textPropertiesView;
	}

	/**
	 * Answer my accpet button.
	 *
	 * @return java.awt.Button
	 * @category interface opening
	 */
	protected Button acceptButton() {
		if (acceptButton == null) {
			acceptButton = new Button(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunTextEditorDialogViewAwt.this.getTextEditorDialog().acceptButtonPressed()) {
						JunTextEditorDialogViewAwt.this.getTextEditorDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return java.awt.Button
	 * @category interface opening
	 */
	protected Button cancelButton() {
		if (cancelButton == null) {
			cancelButton = new Button(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunTextEditorDialogViewAwt.this.getTextEditorDialog().cancelButtonPressed()) {
						JunTextEditorDialogViewAwt.this.getTextEditorDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(Window aWindow) {
		this.textPropertiesView()._setupKeyboard(aWindow);
	}
}
