package jp.co.sra.jun.goodies.tables;

import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.lisp.JunLispParser;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunAttributeTableTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/04/05 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun592 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunAttributeTableTestExamples.java,v 8.12 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunAttributeTableTestExamples extends JunTestExamples {

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunAttributeTable attributes = new JunAttributeTable();
		System.out.println(attributes.printString());

		return true;
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunAttributeTable attributes = new JunAttributeTable();
		attributes.at_put_($("one"), new Integer(1));
		attributes.at_put_($("two"), new Integer(2));
		attributes.at_put_($("three"), new Integer(3));
		attributes.at_put_($("four"), new Integer(4));
		attributes.at_put_($("five"), new Integer(5));
		attributes.at_put_($("six"), new Integer(6));
		attributes.at_put_($("seven"), new Integer(7));
		attributes.at_put_($("eight"), new Integer(8));
		attributes.at_put_($("nine"), new Integer(9));
		attributes.at_put_($("ten"), new Integer(10));
		System.out.println(attributes.printString());

		return true;
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		StringBuffer aStringBuffer = new StringBuffer();
		aStringBuffer.append("	(JunAttributeTable             ");
		aStringBuffer.append("		(size . 10)                ");
		aStringBuffer.append("		(attributeTable            ");
		aStringBuffer.append("			(eight . 8)            ");
		aStringBuffer.append("			(five . 5)             ");
		aStringBuffer.append("			(four . 4)             ");
		aStringBuffer.append("			(nine . 9)             ");
		aStringBuffer.append("			(one . 1)              ");
		aStringBuffer.append("			(seven . 7)            ");
		aStringBuffer.append("			(six . 6)              ");
		aStringBuffer.append("			(ten JunAttributeTable ");
		aStringBuffer.append("				(size . 10)        ");
		aStringBuffer.append("				(attributeTable    ");
		aStringBuffer.append("					(eight . 8)    ");
		aStringBuffer.append("					(five . 5)     ");
		aStringBuffer.append("					(four . 4)     ");
		aStringBuffer.append("					(nine . 9)     ");
		aStringBuffer.append("					(one . 1)      ");
		aStringBuffer.append("					(seven . 7)    ");
		aStringBuffer.append("					(six . 6)      ");
		aStringBuffer.append("					(ten . 10)     ");
		aStringBuffer.append("					(three . 3)    ");
		aStringBuffer.append("					(two . 2)))    ");
		aStringBuffer.append("			(three . 3)            ");
		aStringBuffer.append("			(two . 2)))            ");

		JunLispList list = (JunLispList) JunLispParser.Parse_(aStringBuffer.toString());
		JunAttributeTable attributes = JunAttributeTable.FromLispList_(list);
		System.out.println(attributes.printString());

		return true;
	}

	/**
	 * Example_fromString: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_FromString() {
		StringBuffer aStringBuffer = new StringBuffer();
		aStringBuffer.append("	(JunAttributeTable             ");
		aStringBuffer.append("		(size . 10)                ");
		aStringBuffer.append("		(attributeTable            ");
		aStringBuffer.append("			(eight . 8)            ");
		aStringBuffer.append("			(five . 5)             ");
		aStringBuffer.append("			(four . 4)             ");
		aStringBuffer.append("			(nine . 9)             ");
		aStringBuffer.append("			(one . 1)              ");
		aStringBuffer.append("			(seven . 7)            ");
		aStringBuffer.append("			(six . 6)              ");
		aStringBuffer.append("			(three . 3)            ");
		aStringBuffer.append("			(two . 2)))            ");

		JunAttributeTable attributes = JunAttributeTable.FromString_(aStringBuffer.toString());
		System.out.println(attributes.storeString());

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunAttributeTableTestExamples();
	}

}
