package jp.co.sra.jun.goodies.stopwatch;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.SwingUtilities;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StViewCanvas;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.button.JunButtonViewAwt;
import jp.co.sra.jun.goodies.gauge.JunLevelGaugeViewAwt;

/**
 * JunStopwatchViewAwt class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/04/19 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun652 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunStopwatchViewAwt.java,v 8.7 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunStopwatchViewAwt extends JunLevelGaugeViewAwt implements JunStopwatchView {
	protected StViewCanvas stopwatchView;

	/**
	 * Create a new instance of <code>JunStopwatchViewAwt</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunStopwatchViewAwt() {
		super();
	}

	/**
	 * Create a new instance of <code>JunStopwatchViewAwt</code> and initialize it.
	 * 
	 * @param aModel jp.co.sra.jun.goodies.stopwatch.JunStopwatch
	 * @category Instance creation
	 */
	public JunStopwatchViewAwt(JunStopwatch aModel) {
		super(aModel);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		stopwatchView = null;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.stopwatchView()._onBorderedPanel(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -19, 1f, -1));
		this.add(this.resetButtonView(), WindowSpecLayout.Position(1f, -19, 0.5f, -19, 1f, -1, 0.5f, -1));
		this.add(this.toggleButtonView(), WindowSpecLayout.Position(1f, -19, 0.5f, 1, 1f, -1, 0.5f, 19));
		this.setSize(128, 40);
	}

	/**
	 * Display the receiver's value on the graphics.
	 * 
	 * @param graphicsContext java.awt.Graphics
	 * @category displaying
	 */
	public void displayValueOn_(Graphics graphicsContext) {
		if (this.isShowing() == false) {
			return;
		}

		Font aFont = new Font(System.getProperty("default.font.name", "Dialog"), this.valueStyle(), this.valueSize());
		String aText = this.getStopwatch().displayString();
		StComposedText composedText = new StComposedText(aText, aFont);
		Point topLeft = new Point((this.stopwatchView().getWidth() - composedText.width()) / 2, (this.stopwatchView().getHeight() - composedText.height()) / 2);
		graphicsContext.setColor(this.backgroundColor());
		graphicsContext.fillRect(topLeft.x, topLeft.y, composedText.width(), composedText.height());
		graphicsContext.setColor(this.valueColor());
		composedText.displayOn_at_(graphicsContext, topLeft);
	}

	/**
	 * Answer the stop watch view.
	 * 
	 * @return jp.co.sra.smalltalk.StViewCanvas
	 * @category interface opening
	 */
	protected StViewCanvas stopwatchView() {
		if (stopwatchView == null) {
			stopwatchView = new StViewCanvas(this.getStopwatch()) {
				public void displayOn_(Graphics aGraphics) {
					JunStopwatchViewAwt.this.displayValueOn_(aGraphics);
				}
			};
			stopwatchView.setBackground(this.getModel().backgroundColor());
		}
		return stopwatchView;
	}

	/**
	 * Answer the reset button view.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category interface opening
	 */
	protected JunButtonViewAwt resetButtonView() {
		return new JunButtonViewAwt(this.getStopwatch().resetButton());
	}

	/**
	 * Answer the toggle button view.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category interface opening
	 */
	protected JunButtonViewAwt toggleButtonView() {
		return new JunButtonViewAwt(this.getStopwatch().toggleButton());
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(final Window aWindow) {
		KeyListener keyListener = this.getStopwatch()._keyListener();
		if (keyListener == null) {
			return;
		}

		this.addKeyListener(keyListener);

		aWindow.addWindowListener(new WindowAdapter() {
			public void windowActivated(WindowEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						Component focusOwner = aWindow.getFocusOwner();
						if (focusOwner == null || focusOwner != JunStopwatchViewAwt.this) {
							JunStopwatchViewAwt.this.requestFocus();
						}
					}
				});
			}
		});
	}

	/**
	 * Answer the receiver's model as <code>JunStopwatch</code>.
	 * 
	 * @return jp.co.sra.jun.goodies.stopwatch.JunStopwatch
	 * @see jp.co.sra.jun.goodies.stopwatch.JunStopwatchView#getStopwatch()
	 * @category model accessing
	 */
	public JunStopwatch getStopwatch() {
		return (JunStopwatch) this.model();
	}

	/**
	 * Answer the value size.
	 * 
	 * @return int
	 * @category preferences
	 */
	public int valueSize() {
		return this.getStopwatch().valueSize();
	}

	/**
	 * Answer the value style.
	 * 
	 * @return int
	 * @category preferences
	 */
	public int valueStyle() {
		return this.getStopwatch().valueStyle();
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a
	 * dependent.  The argument anAspectSymbol is typically a Symbol that
	 * indicates what change has occurred.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		StSymbol aspectSymbol = evt.getAspect();
		if (aspectSymbol == $("value")) {
			Graphics aGraphics = this.stopwatchView().getGraphics();
			try {
				this.displayValueOn_(aGraphics);
			} finally {
				if (aGraphics != null) {
					aGraphics.dispose();
				}
			}
			return;
		}
		super.update_(evt);
	}
}
