package jp.co.sra.jun.goodies.stopwatch;

import java.awt.Color;
import java.awt.Font;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunStopwatchTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/04/19 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun652 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunStopwatchTestExamples.java,v 8.6 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunStopwatchTestExamples extends JunTestExamples {
	/**
	 * Example1: Open a JunStopwatch.
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunStopwatch stopwatch = new JunStopwatch();
		stopwatch.open();

		return true;
	}

	/**
	 * Example2: Open a JunStopwatch.
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunStopwatch stopwatch = new JunStopwatch();
		stopwatch.tickTime_(50);
		stopwatch.backgroundColor_(Color.yellow);
		stopwatch.valueColor_(Color.red);
		stopwatch.valueSize_(10);
		stopwatch.valueStyle_(Font.BOLD);
		stopwatch.open();

		return true;
	}

	/**
	 * Example3: Open a JunStopwatch.
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		(new Thread() {
			public void run() {
				JunStopwatch aStopwatch = new JunStopwatch();
				aStopwatch.open();
				try {
					this.sleep(1000);
				} catch (InterruptedException e) {
				}
				aStopwatch.start();
				try {
					this.sleep(10000);
				} catch (InterruptedException e) {
				}
				aStopwatch.stop();
				try {
					this.sleep(1000);
				} catch (InterruptedException e) {
				}
				aStopwatch.zero();
			}
		}).start();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunStopwatchTestExamples();
	}
}
