package jp.co.sra.jun.goodies.spirodesign;

import java.awt.Point;

import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunSpiroDesignView interface
 * 
 *  @author    m-asada
 *  @created   2006/03/28 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun676 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSpiroDesignView.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public interface JunSpiroDesignView extends JunAbstractView {
	/**
	 * Answer my default controller as JunSpiroDesignController.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignController
	 * @category controller accessing
	 */
	public JunSpiroDesignController getSpiroDesignController();

	/**
	 * Convert model point to view point, and answer it.
	 * 
	 * @param aPoint java.awt.Point
	 * @return java.awt.Point
	 * @category converting
	 */
	public Point convertModelPointToViewPoint_(Point aPoint);

	/**
	 * Convert view point to model point, and answer it.
	 * 
	 * @param aPoint java.awt.Point
	 * @return java.awt.Point
	 * @category converting
	 */
	public Point convertViewPointToModelPoint_(Point aPoint);

	/**
	 * Answer the receiver's model as JunSpiroDesignAbstractModel.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel
	 * @category model accessing
	 */
	public JunSpiroDesignAbstractModel getModel();

	/**
	 * Answer the receiver's scroll amount.
	 * 
	 * @return java.awt.Point
	 * @category scrolling
	 */
	public Point scrollAmount();

	/**
	 * Scroll by the specified point and repaint the receiver.
	 * 
	 * @param aPoint java.awt.Point
	 * @category scrolling
	 */
	public void scrollBy_(Point aPoint);
}
