package jp.co.sra.jun.goodies.sound;

import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunSoundMeterViewAwt class
 * 
 *  @author    Hoshi Takanori
 *  @created   2003/08/29 (by Hoshi Takanori)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun433 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSoundMeterViewAwt.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSoundMeterViewAwt extends JunAbstractViewPanel implements JunSoundMeterView {

	protected JunSoundLevelMeterViewAwt soundLevelMeterView;
	protected JunSoundWaveMeterViewAwt soundWaveMeterView;

	/**
	 * Create a new instance of JunSoundMeterViewAwt and initialize it.
	 *
	 * @param aSoundMeterModel jp.co.sra.jun.goodies.sound.JunSoundMeterModel
	 */
	public JunSoundMeterViewAwt(JunSoundMeterModel aSoundMeterModel) {
		super(aSoundMeterModel);
	}

	/**
	 * Answer my model as JunSoundMeterModel.
	 *
	 * @return jp.co.sra.jun.goodies.sound.JunSoundMeterModel
	 */
	public JunSoundMeterModel getSoundMeterModel() {
		return (JunSoundMeterModel) this.model();
	}

	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.soundWaveMeterView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -11));
		this.add(this.soundLevelMeterView(), WindowSpecLayout.Position(0f, 1, 1f, -10, 1f, -1, 1f, -1));
		this.setSize(500, 64);
	}

	/**
	 * Answer the sound level meter view.
	 *
	 * @return jp.co.sra.jun.goodies.sound.JunSoundLevelMeterViewAwt
	 */
	protected JunSoundLevelMeterViewAwt soundLevelMeterView() {
		if (soundLevelMeterView == null) {
			soundLevelMeterView = new JunSoundLevelMeterViewAwt(this.getSoundMeterModel());
		}
		return soundLevelMeterView;
	}

	/**
	 * Answer the sound wave meter view.
	 *
	 * @return jp.co.sra.jun.goodies.sound.JunSoundWaveMeterViewAwt
	 */
	protected JunSoundWaveMeterViewAwt soundWaveMeterView() {
		if (soundWaveMeterView == null) {
			soundWaveMeterView = new JunSoundWaveMeterViewAwt(this.getSoundMeterModel());
		}
		return soundWaveMeterView;
	}
}
