package jp.co.sra.jun.goodies.soroban;

import jp.co.sra.smalltalk.StRectangle;

import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunSorobanView interface
 * 
 *  @author    m-asada
 *  @created   2006/03/13 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun563 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSorobanView.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public interface JunSorobanView extends JunAbstractView {
	/**
	 * Answer the receiver's model as JunSorobanModel.
	 * 
	 * @return jp.co.sra.jun.goodies.soroban.JunSorobanModel
	 * @category model accessing
	 */
	public JunSorobanModel getModel();

	/**
	 * Answer the koma image height.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int komaHeight();

	/**
	 * Answer the kushi image height.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int kushiHeight();

	/**
	 * Answer the margin rectangle.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category accessing
	 */
	public StRectangle marginRectangle();

	/**
	 * Answer the reed image height.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int reedHeight();

	/**
	 * Answer the reed image width.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int reedWidth();
}
