package jp.co.sra.jun.goodies.revision;

import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StValued;

/**
 * JunHistoryNode class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/14 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun500 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunHistoryNode.java,v 8.4 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunHistoryNode extends StObject {
	protected JunHistoryNode parent;
	protected StValued operation;
	protected String comment;

	/**
	 * Create a new instance of <code>JunHistoryNode</code> and initialize it.
	 * 
	 * @param evaluatableObject jp.co.sra.smalltalk.StValued
	 * @category Instance creation
	 */
	public JunHistoryNode(StValued  evaluatableObject) {
		super();
		this.operation_(evaluatableObject);
	}

	/**
	 * Answer the receiver's comment.
	 * 
	 * @return comment
	 * @category accessing
	 */
	public String comment() {
		return comment;
	}

	/**
	 * Set the receiver's comment.
	 * 
	 * @param aString java.lang.String
	 * @category accessing
	 */
	public void comment_(String aString) {
		comment = aString;
	}

	/**
	 * Answer the receiver's operation.
	 * 
	 * @return jp.co.sra.smalltalk.StValued
	 * @category accessing
	 */
	public StValued operation() {
		return operation;
	}

	/**
	 * Set the receiver's operation.
	 * 
	 * @param evaluatableObject jp.co.sra.smalltalk.StValued
	 * @category accessing
	 */
	public void operation_(StValued evaluatableObject) {
		operation = evaluatableObject;
	}

	/**
	 * Answer the receiver's parent.
	 * 
	 * @return jp.co.sra.jun.goodies.revision.JunHistoryNode
	 * @category accessing
	 */
	public JunHistoryNode parent() {
		return parent;
	}

	/**
	 * Set the receiver's parent.
	 * 
	 * @param aJunSolidModelingHistoryNode jp.co.sra.jun.goodies.revision.JunHistoryNode
	 * @category accessing
	 */
	public void parent_(JunHistoryNode aJunSolidModelingHistoryNode) {
		parent = aJunSolidModelingHistoryNode;
	}
}
