package jp.co.sra.jun.goodies.prolog;

import java.io.*;

/**
 * JunPrologTerms class
 * 
 *  @author    kondo
 *  @created   1999/09/09 (by kondo)
 *  @updated   2003/04/30 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologTerms.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologTerms extends JunPrologList {

	/**
	 * Create a new instance of JunPrologTerms and initialize it with the car part and the cdr part.
	 *
	 * @param anObject jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 * @param link jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	public JunPrologTerms(JunPrologEntity anObject, JunPrologEntity link) {
		this.term_next_(anObject, link);
	}

	/**
	 * Create a new instance of JunPrologTerms from the list.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologTerms
	 * @param aJunPrologDotPair jp.co.sra.jun.goodies.prolog.JunPrologList
	 */
	public static JunPrologTerms FromList_(JunPrologList aJunPrologDotPair) {
		return FromReverseList_(aJunPrologDotPair.reverse());
	}

	/**
	 * Create a new instance of JunPrologTerms from the reverse list.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologTerms
	 * @param aJunPrologDotPair jp.co.sra.jun.goodies.prolog.JunPrologList
	 */
	public static JunPrologTerms FromReverseList_(JunPrologList aJunPrologDotPair) {
		JunPrologEntity list = aJunPrologDotPair;
		JunPrologList mark = null;
		JunPrologTerms terms = null;
		while (list != null && list.consp()) {
			if (terms == null) {
				mark = terms = new JunPrologTerms(list.car(), terms);
			} else {
				terms = new JunPrologTerms(list.car(), terms);
			}
			list = list.cdr();
		}
		mark.cdr_(list);
		return terms;
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException if failed.
	 */
	public void printJunPrologOn_(Writer aWriter) throws IOException {
		aWriter.write('(');
		JunPrologEntity list = this;
		while (list.cdr() != null && list.cdr().consp()) {
			if (list != this) {
				aWriter.write(',');
			}
			list._carPrintJunPrologOn_(aWriter);
			list = list.cdr();
		}
		if (list != this) {
			aWriter.write(',');
		}

		list._carPrintJunPrologOn_(aWriter);

		if (list.cdr() == null) {
			aWriter.write(')');
		} else {
			aWriter.write('|');
			list.cdr().printJunPrologOn_(aWriter);
			aWriter.write(')');
		}
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param anInteger int
	 * @throws IOException if failed.
	 */
	public void printJunPrologOn_level_(Writer aWriter, int anInteger) throws IOException {
		this.printJunPrologOn_(aWriter);
	}

	/**
	 * Create a new instance with the specified arguments.
	 * This method have to be overrided to create a subclass specified instance.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologList
	 * @param carEntity jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 * @param cdrEntity jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	protected JunPrologList _newInstanceWith(JunPrologEntity carEntity, JunPrologEntity cdrEntity) {
		return new JunPrologTerms(carEntity, cdrEntity);
	}

	/**
	 * Set the car part and the cdr part.
	 *
	 * @param anObject jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 * @param link jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	protected void term_next_(JunPrologEntity anObject, JunPrologEntity link) {
		carPart = anObject;
		cdrPart = link;
	}
}
