package jp.co.sra.jun.goodies.prolog;

import jp.co.sra.smalltalk.*;

/**
 * JunPrologScannerTable class
 * 
 *  @author    kondo
 *  @created   1999/09/09 (by kondo)
 *  @updated   2003/04/25 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologScannerTable.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologScannerTable extends StObject {

	protected static StSymbol[] ScanningTable;

	static {
		Initialize();
	}

	/**
	 * Answer the scanner table.
	 * 
	 * @return StSymbol[]
	 */
	public static StSymbol[] ScannerTable() {
		return ScanningTable;
	}

	/**
	 * Initialize the scanning table.
	 */
	protected static void Initialize() {
		StSymbol[] newTable = new StSymbol[256];
		for (int i = 0; i < 256; i++) {
			newTable[i] = $("xBinary");
		}

		newTable[9] = $("xDelimiter");
		newTable[10] = $("xDelimiter");
		newTable[12] = $("xDelimiter");
		newTable[13] = $("xDelimiter");
		newTable[32] = $("xDelimiter");

		for (char c = '0'; c <= '9'; c++) {
			newTable[c] = $("xDigit");
		}

		for (char c = 'A'; c <= 'Z'; c++) {
			newTable[c] = $("xVariable");
		}
		newTable['~'] = $("xVariable");

		for (char c = 'a'; c <= 'z'; c++) {
			newTable[c] = $("xSymbol");
		}
		for (int i = 128; i < 256; i++) {
			newTable[i] = $("xSymbol");
		}
		newTable['!'] = $("xSymbol");
		newTable['*'] = $("xSymbol");
		newTable['/'] = $("xSymbol");
		newTable['\\'] = $("xSymbol");
		newTable['>'] = $("xSymbol");
		newTable['<'] = $("xSymbol");
		newTable['='] = $("xSymbol");
		newTable['_'] = $("xSymbol");
		newTable['$'] = $("xSymbol"); // $("xDollar");

		newTable['^'] = $("eof");
		newTable['"'] = $("xDoubleQuote");
		newTable['\''] = $("xSingleQuote");
		newTable['('] = $("leftParenthesis");
		newTable[')'] = $("rightParenthesis");
		newTable['.'] = $("period");
		newTable[':'] = $("xColon");
		newTable['?'] = $("xColon");
		newTable[';'] = $("semicolon");
		newTable['['] = $("leftBracket");
		newTable[']'] = $("rightBracket");
		newTable['{'] = $("leftBrace");
		newTable['}'] = $("rightBrace");
		newTable[','] = $("comma");
		newTable['|'] = $("verticalBar");
		newTable['+'] = $("xSign");
		newTable['-'] = $("xSign");
		newTable['%'] = $("xComment");

		ScanningTable = newTable;

	}
}
