package jp.co.sra.jun.goodies.prolog;

import java.io.*;
import java.util.*;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunPrologInterpreterTestExamples class
 * 
 *  @author    kondo
 *  @created   1999/09/16 (by kondo)
 *  @updated   2003/04/24 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologInterpreterTestExamples.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologInterpreterTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Open a JunPrologInterpreter.
	 * 
	 * @return boolean
	 */
	public static boolean Example() {
		(new JunPrologInterpreter()).open();

		return true;
	}

	/**
	 * Example01: 
	 * 
	 * @return boolean
	 */
	public static boolean Example01() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = null;
		try {
			pw = new PrintWriter(sw);
			pw.println("	?- remove.	   % remove all predicates in JunPrologDataBase.");
			pw.println("	likes(john,mary).    % assert fact.");
			pw.println("	likes(john,wine).    % assert fact.");
			pw.println("	likes(mary,wine).    % assert fact.");
			pw.println("	likes(mary,john).    % assert fact.");
			pw.println("	?- likes(X,Y).		   % question goal.");
			pw.println("	?- likes(john,X), likes(mary,X). % question goal.");
		} finally {
			if (pw != null) {
				pw.flush();
				pw.close();
			}
		}

		String string = sw.toString();
		final JunPrologInterpreter prolog = new JunPrologInterpreter();
		prolog.textCollector_(System.out);
		boolean result = prolog.refute_action_(string, new StBlockClosure() {
			public Object value_(Object argument) {
				Hashtable answer = (Hashtable) argument;
				Object[] keys = answer.keySet().toArray();
				Arrays.sort(keys);
				for (int i = 0; i < keys.length; i++) {
					Object s = keys[i];
					System.out.print(s);
					System.out.print(" = ");
					System.out.print(((JunPrologEntity) answer.get(s)).printJunPrologString());
					System.out.println();
				}
				return new Boolean(prolog.confirm_(JunSystem.$String("All right?")));
			}
		});
		System.out.println(result);

		return true;
	}

	/**
	 * Example02: 
	 * 
	 * @return boolean
	 */
	public static boolean Example02() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = null;
		try {
			pw = new PrintWriter(sw);
			pw.println("	?- remove.	   % remove all predicates in JunPrologDataBase.");
			pw.println("	on(hen,cat).");
			pw.println("	on(cat,dog).");
			pw.println("	on(dog,donkey).");
			pw.println("	above(X,Y) :-");
			pw.println("	    on(X,Y).");
			pw.println("	above(X,Y) :-");
			pw.println("	    on(X,Z), above(Z,Y).");
			pw.println("	?- on(X,dog).");
			pw.println("	?- above(X,dog).");
		} finally {
			if (pw != null) {
				pw.flush();
				pw.close();
			}
		}

		String string = sw.toString();
		final JunPrologInterpreter prolog = new JunPrologInterpreter();
		prolog.textCollector_(System.out);
		boolean result = prolog.refute_action_(string, new StBlockClosure() {
			public Object value_(Object argument) {
				Hashtable answer = (Hashtable) argument;
				Object[] keys = answer.keySet().toArray();
				Arrays.sort(keys);
				for (int i = 0; i < keys.length; i++) {
					Object s = keys[i];
					System.out.print(s);
					System.out.print(" = ");
					System.out.print(((JunPrologEntity) answer.get(s)).printJunPrologString());
					System.out.println();
				}
				return new Boolean(prolog.confirm_(JunSystem.$String("All right?")));
			}
		});
		System.out.println(result);

		return true;
	}

	/**
	 * Example03: 
	 * 
	 * @return boolean
	 */
	public static boolean Example03() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = null;
		try {
			pw = new PrintWriter(sw);
			pw.println("	?- remove.	   % remove all predicates in JunPrologDataBase.");
			pw.println("	hanoi(N) :-	% This is Hanoi Tower Prolgram.");
			pw.println("	    move(N,left,right,center).");
			pw.println("	    move(0,X,Y,Z) :- !.");
			pw.println("	move(N,A,B,C) :-");
			pw.println("	    -(N,1,M),");
			pw.println("	    move(M,A,C,B),");
			pw.println("	    inform(A,B),");
			pw.println("	    move(M,C,B,A).");
			pw.println("	inform(X,Y) :-");
			pw.println("	    write([move,disc,from,X,to,Y]),");
			pw.println("	    nl.");
			pw.println("	?- hanoi(3).	 % question goal.");
		} finally {
			if (pw != null) {
				pw.flush();
				pw.close();
			}
		}

		String string = sw.toString();
		final JunPrologInterpreter prolog = new JunPrologInterpreter();
		prolog.textCollector_(System.out);
		boolean result = prolog.refute_action_(string, new StBlockClosure() {
			public Object value_(Object argument) {
				Hashtable answer = (Hashtable) argument;
				Object[] keys = answer.keySet().toArray();
				Arrays.sort(keys);
				for (int i = 0; i < keys.length; i++) {
					Object s = keys[i];
					System.out.print(s);
					System.out.print(" = ");
					System.out.print(((JunPrologEntity) answer.get(s)).printJunPrologString());
					System.out.println();
				}
				return new Boolean(prolog.confirm_(JunSystem.$String("All right?")));
			}
		});
		System.out.println(result);

		return true;
	}

	/**
	 * Example04: 
	 * 
	 * @return boolean
	 */
	public static boolean Example04() {
		String string = "?- append(X,Y,[a,b,c,d]).";
		final JunPrologInterpreter prolog = new JunPrologInterpreter();
		prolog.textCollector_(System.out);
		boolean result = prolog.refute_action_(string, new StBlockClosure() {
			public Object value_(Object argument) {
				Hashtable answer = (Hashtable) argument;
				Object[] keys = answer.keySet().toArray();
				Arrays.sort(keys);
				for (int i = 0; i < keys.length; i++) {
					Object s = keys[i];
					System.out.print(s);
					System.out.print(" = ");
					System.out.print(((JunPrologEntity) answer.get(s)).printJunPrologString());
					System.out.println();
				}
				return new Boolean(prolog.confirm_(JunSystem.$String("All right?")));
			}
		});
		System.out.println(result);

		return true;
	}

	/**
	 * Example06: 
	 * 
	 * @return boolean
	 */
	public static boolean Example06() {
		String string = "?- send(123,+,[456],X).   % X := 123 + 456.";
		final JunPrologInterpreter prolog = new JunPrologInterpreter();
		prolog.textCollector_(System.out);
		boolean result = prolog.refute_action_(string, new StBlockClosure() {
			public Object value_(Object argument) {
				Hashtable answer = (Hashtable) argument;
				Object[] keys = answer.keySet().toArray();
				Arrays.sort(keys);
				for (int i = 0; i < keys.length; i++) {
					Object s = keys[i];
					System.out.print(s);
					System.out.print(" = ");
					System.out.print(((JunPrologEntity) answer.get(s)).printJunPrologString());
					System.out.println();
				}
				return new Boolean(prolog.confirm_(JunSystem.$String("All right?")));
			}
		});
		System.out.println(result);

		return true;
	}

	/**
	 * Example07: 
	 * 
	 * @return boolean
	 */
	public static boolean Example07() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = null;
		try {
			pw = new PrintWriter(sw);
			pw.println("	?- is(X,+(3,4)).");
			pw.println("	?- is(X,F(3,4)).");
		} finally {
			if (pw != null) {
				pw.flush();
				pw.close();
			}
		}

		String string = sw.toString();
		final JunPrologInterpreter prolog = new JunPrologInterpreter();
		prolog.textCollector_(System.out);
		boolean result = prolog.refute_action_(string, new StBlockClosure() {
			public Object value_(Object argument) {
				Hashtable answer = (Hashtable) argument;
				Object[] keys = answer.keySet().toArray();
				Arrays.sort(keys);
				for (int i = 0; i < keys.length; i++) {
					Object s = keys[i];
					System.out.print(s);
					System.out.print(" = ");
					System.out.print(((JunPrologEntity) answer.get(s)).printJunPrologString());
					System.out.println();
				}
				return new Boolean(prolog.confirm_(JunSystem.$String("All right?")));
			}
		});
		System.out.println(result);

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunPrologInterpreterTestExamples();
	}
}
