package jp.co.sra.jun.goodies.progress;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunCursorAnimator class
 * 
 *  @author    nisinaka
 *  @created   2001/11/20 (by nisinaka)
 *  @updated   2002/04/04 (by nisinaka)
 *  @updated   2003/05/14 (by nisinaka)
 *  @updated   2007/04/12 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCursorAnimator.java,v 8.16 2008/02/20 06:32:01 nisinaka Exp $
 */
public class JunCursorAnimator extends JunAbstractObject {
	protected static final int WIDTH = 16;
	protected static final int HEIGHT = 16;
	protected static Cursor[] ClockCursors = null;
	protected static Cursor[] HandCursors = null;
	protected static Cursor[] StopwatchCursors = null;

	protected Cursor[] cursors = new Cursor[0];
	protected int tick = 1000;
	protected Frame[] _frames = null;
	protected Cursor[] _savedCursors;
	protected Thread _process;
	protected boolean _finished;

	/**
	 * Create a new instance of <code>JunCursorAnimator</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunCursorAnimator() {
		super();
	}

	/**
	 * Create a new instance of <code>JunCursorAnimator</code> and initialize it.
	 * 
	 * @param cursors java.awt.Cursor[]
	 * @category Instance creation
	 */
	public JunCursorAnimator(Cursor[] cursors) {
		this();
		this.cursors_(cursors);
	}

	/**
	 * Create the clock cursors.
	 * 
	 * @return jp.co.sra.jun.goodies.progress.JunCursorAnimator
	 * @category Instance creation
	 */
	public static JunCursorAnimator ClockCursors() {
		if (ClockCursors == null) {
			ClockCursors = new Cursor[] { ClockCursor0(), ClockCursor1(), ClockCursor2(), ClockCursor3(), ClockCursor4(), ClockCursor5(), ClockCursor6(), ClockCursor7() };
		}
		return new JunCursorAnimator(ClockCursors);
	}

	/**
	 * Create the hand cursors.
	 * 
	 * @return jp.co.sra.jun.goodies.progress.JunCursorAnimator
	 * @category Instance creation
	 */
	public static JunCursorAnimator HandCursors() {
		if (HandCursors == null) {
			HandCursors = new Cursor[] { HandCursor0(), HandCursor1(), HandCursor2(), HandCursor3(), HandCursor4(), HandCursor5(), HandCursor4(), HandCursor3(), HandCursor2(), HandCursor1() };
		}
		return new JunCursorAnimator(HandCursors);
	}

	/**
	 * Create the stopwatch cursors.
	 * 
	 * @return jp.co.sra.jun.goodies.progress.JunCursorAnimator
	 * @category Instance creation
	 */
	public static JunCursorAnimator StopwatchCursors() {
		if (StopwatchCursors == null) {
			StopwatchCursors = new Cursor[] { StopwatchCursor0(), StopwatchCursor1(), StopwatchCursor2(), StopwatchCursor3(), StopwatchCursor4(), StopwatchCursor5(), StopwatchCursor6(), StopwatchCursor7(), };
		}
		return new JunCursorAnimator(StopwatchCursors);
	}

	/**
	 * Create an image from the array of pixels.
	 * 
	 * @param pixels int[]
	 * @return java.awt.image.BufferedImage
	 * @category Image utilities
	 */
	private static BufferedImage _CreateImage(int[] pixels) {
		BufferedImage image = new BufferedImage(WIDTH, HEIGHT, BufferedImage.TYPE_INT_ARGB);
		image.setRGB(0, 0, WIDTH, HEIGHT, pixels, 0, WIDTH);
		return image;
	}

	/**
	 * Create an array of pixels from an image string and a mask string.
	 * 
	 * @param imageString java.lang.String
	 * @param maskString java.lang.String
	 * @return int[]
	 * @category Image utilities
	 */
	private static int[] _Pixels(String imageString, String maskString) {
		int[] pixels = new int[WIDTH * HEIGHT];
		for (int i = 0; i < (WIDTH * HEIGHT); i++) {
			int pixel = 0;
			if (imageString.charAt(i) != '0') {
				pixel = Color.black.getRGB();
			} else if (maskString.charAt(i) != '0') {
				pixel = Color.white.getRGB();
			}
			pixels[i] = pixel;
		}
		return pixels;
	}

	/**
	 * Resize the image to fit as a cursor.
	 * 
	 * @param anImage java.awt.image.BufferedImage
	 * @return java.awt.image.BufferedImage
	 * @category Image utilities
	 */
	private static BufferedImage _ResizeToFit(BufferedImage anImage) {
		Dimension size = Toolkit.getDefaultToolkit().getBestCursorSize(WIDTH, HEIGHT);
		BufferedImage cursorImage = new BufferedImage(size.width, size.height, BufferedImage.TYPE_INT_ARGB);
		cursorImage.setData(anImage.getRaster());
		return cursorImage;
	}

	/**
	 * Answer the clock cursor #0.
	 * 
	 * @return java.awt.Cursor
	 * @category Clock cursors
	 */
	protected static Cursor ClockCursor0() {
		String imageString = "";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0100000010000000";
		imageString += "1000010001000000";
		imageString += "1000010001000000";
		imageString += "1000010001100000";
		imageString += "1001110001100000";
		imageString += "1000000001000000";
		imageString += "1000000001000000";
		imageString += "0100000010000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";

		String maskString = "";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0111111110000000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "1111111111100000";
		maskString += "1111111111100000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "0111111110000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(5, 7), "clock0");
	}

	/**
	 * Answer the clock cursor #1.
	 * 
	 * @return java.awt.Cursor
	 * @category Clock cursors
	 */
	protected static Cursor ClockCursor1() {
		String imageString = "";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0100000010000000";
		imageString += "1000000001000000";
		imageString += "1000000101000000";
		imageString += "1000001001100000";
		imageString += "1001110001100000";
		imageString += "1000000001000000";
		imageString += "1000000001000000";
		imageString += "0100000010000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";

		String maskString = "";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0111111110000000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "1111111111100000";
		maskString += "1111111111100000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "0111111110000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(5, 7), "clock1");
	}

	/**
	 * Answer the clock cursor #2.
	 * 
	 * @return java.awt.Cursor
	 * @category Clock cursors
	 */
	protected static Cursor ClockCursor2() {
		String imageString = "";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0100000010000000";
		imageString += "1000000001000000";
		imageString += "1000000001000000";
		imageString += "1000000001100000";
		imageString += "1001111101100000";
		imageString += "1000000001000000";
		imageString += "1000000001000000";
		imageString += "0100000010000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";

		String maskString = "";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0111111110000000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "1111111111100000";
		maskString += "1111111111100000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "0111111110000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(5, 7), "clock2");
	}

	/**
	 * Answer the clock cursor #3.
	 * 
	 * @return java.awt.Cursor
	 * @category Clock cursors
	 */
	protected static Cursor ClockCursor3() {
		String imageString = "";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0100000010000000";
		imageString += "1000000001000000";
		imageString += "1000000001000000";
		imageString += "1000000001100000";
		imageString += "1001110001100000";
		imageString += "1000001001000000";
		imageString += "1000000001000000";
		imageString += "0100000010000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";

		String maskString = "";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0111111110000000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "1111111111100000";
		maskString += "1111111111100000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "0111111110000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(5, 7), "clock3");
	}

	/**
	 * Answer the clock cursor #4.
	 * 
	 * @return java.awt.Cursor
	 * @category Clock cursors
	 */
	protected static Cursor ClockCursor4() {
		String imageString = "";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0100000010000000";
		imageString += "1000000001000000";
		imageString += "1000000001000000";
		imageString += "1000000001100000";
		imageString += "1001110001100000";
		imageString += "1000010001000000";
		imageString += "1000010001000000";
		imageString += "0100000010000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";

		String maskString = "";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0111111110000000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "1111111111100000";
		maskString += "1111111111100000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "0111111110000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(5, 7), "clock4");
	}

	/**
	 * Answer the clock cursor #5.
	 * 
	 * @return java.awt.Cursor
	 * @category Clock cursors
	 */
	protected static Cursor ClockCursor5() {
		String imageString = "";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0100000010000000";
		imageString += "1000000001000000";
		imageString += "1000000001000000";
		imageString += "1000000001100000";
		imageString += "1001110001100000";
		imageString += "1000100001000000";
		imageString += "1001000001000000";
		imageString += "0100000010000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";

		String maskString = "";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0111111110000000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "1111111111100000";
		maskString += "1111111111100000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "0111111110000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(5, 7), "clock5");
	}

	/**
	 * Answer the clock cursor #6.
	 * 
	 * @return java.awt.Cursor
	 * @category Clock cursors
	 */
	protected static Cursor ClockCursor6() {
		String imageString = "";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0100000010000000";
		imageString += "1000000001000000";
		imageString += "1000000001000000";
		imageString += "1000000001100000";
		imageString += "1011110001100000";
		imageString += "1000000001000000";
		imageString += "1000000001000000";
		imageString += "0100000010000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";

		String maskString = "";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0111111110000000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "1111111111100000";
		maskString += "1111111111100000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "0111111110000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(5, 7), "clock6");
	}

	/**
	 * Answer the clock cursor #7.
	 * 
	 * @return java.awt.Cursor
	 * @category Clock cursors
	 */
	protected static Cursor ClockCursor7() {
		String imageString = "";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0100000010000000";
		imageString += "1000000001000000";
		imageString += "1001000001000000";
		imageString += "1000100001100000";
		imageString += "1001110001100000";
		imageString += "1000000001000000";
		imageString += "1000000001000000";
		imageString += "0100000010000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";
		imageString += "0011111100000000";

		String maskString = "";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0111111110000000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "1111111111100000";
		maskString += "1111111111100000";
		maskString += "1111111111000000";
		maskString += "1111111111000000";
		maskString += "0111111110000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";
		maskString += "0011111100000000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(5, 7), "clock7");
	}

	/**
	 * Answer the hand cursor #0.
	 * 
	 * @return java.awt.Cursor
	 * @category Hand cursors
	 */
	protected static Cursor HandCursor0() {
		String imageString = "";
		imageString += "0000000110000000";
		imageString += "0001101001110000";
		imageString += "0010011001001000";
		imageString += "0010011001001010";
		imageString += "0001001001001101";
		imageString += "0001001001001001";
		imageString += "0110100000001001";
		imageString += "1001100000000001";
		imageString += "1000100000000010";
		imageString += "0100000000000010";
		imageString += "0010000000000010";
		imageString += "0010000000000100";
		imageString += "0001000000000100";
		imageString += "0000100000001000";
		imageString += "0000010000001000";
		imageString += "0000010000001000";

		String maskString = "";
		maskString += "0000000110000000";
		maskString += "0001101111110000";
		maskString += "0011111111111000";
		maskString += "0011111111111010";
		maskString += "0001111111111111";
		maskString += "0001111111111111";
		maskString += "0110111111111111";
		maskString += "1111111111111111";
		maskString += "1111111111111110";
		maskString += "0111111111111110";
		maskString += "0011111111111110";
		maskString += "0011111111111100";
		maskString += "0001111111111100";
		maskString += "0000111111111000";
		maskString += "0000011111111000";
		maskString += "0000011111111000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 7), "hand0");
	}

	/**
	 * Answer the hand cursor #1.
	 * 
	 * @return java.awt.Cursor
	 * @category Hand cursors
	 */
	protected static Cursor HandCursor1() {
		String imageString = "";
		imageString += "0000000110000000";
		imageString += "0001101001110000";
		imageString += "0010011001001000";
		imageString += "0010011001001010";
		imageString += "0001001001001101";
		imageString += "0001001001001001";
		imageString += "0000100000001001";
		imageString += "0000100000000001";
		imageString += "0001100000000010";
		imageString += "0010000000000010";
		imageString += "0010000000000010";
		imageString += "0010000000000100";
		imageString += "0001000000000100";
		imageString += "0000100000001000";
		imageString += "0000010000001000";
		imageString += "0000010000001000";

		String maskString = "";
		maskString += "0000000110000000";
		maskString += "0001101111110000";
		maskString += "0011111111111000";
		maskString += "0011111111111010";
		maskString += "0001111111111111";
		maskString += "0001111111111111";
		maskString += "0000111111111111";
		maskString += "0000111111111111";
		maskString += "0001111111111110";
		maskString += "0011111111111110";
		maskString += "0011111111111110";
		maskString += "0011111111111100";
		maskString += "0001111111111100";
		maskString += "0000111111111000";
		maskString += "0000011111111000";
		maskString += "0000011111111000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 7), "hand1");
	}

	/**
	 * Answer the hand cursor #2.
	 * 
	 * @return java.awt.Cursor
	 * @category Hand cursors
	 */
	protected static Cursor HandCursor2() {
		String imageString = "";
		imageString += "0000000110000000";
		imageString += "0000001001110000";
		imageString += "0000001001001000";
		imageString += "0000001001001010";
		imageString += "0000111001001101";
		imageString += "0001001001001001";
		imageString += "0001000000001001";
		imageString += "0000100000000001";
		imageString += "0001100000000010";
		imageString += "0010000000000010";
		imageString += "0010000000000010";
		imageString += "0010000000000100";
		imageString += "0001000000000100";
		imageString += "0000100000001000";
		imageString += "0000010000001000";
		imageString += "0000010000001000";

		String maskString = "";
		maskString += "0000000110000000";
		maskString += "0000001111110000";
		maskString += "0000001111111000";
		maskString += "0000001111111010";
		maskString += "0000111111111111";
		maskString += "0001111111111111";
		maskString += "0001111111111111";
		maskString += "0000111111111111";
		maskString += "0001111111111110";
		maskString += "0011111111111110";
		maskString += "0011111111111110";
		maskString += "0011111111111100";
		maskString += "0001111111111100";
		maskString += "0000111111111000";
		maskString += "0000011111111000";
		maskString += "0000011111111000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 7), "hand2");
	}

	/**
	 * Answer the hand cursor #3.
	 * 
	 * @return java.awt.Cursor
	 * @category Hand cursors
	 */
	protected static Cursor HandCursor3() {
		String imageString = "";
		imageString += "0000000000000000";
		imageString += "0000000000110000";
		imageString += "0000000001001000";
		imageString += "0000000001001010";
		imageString += "0000110111001101";
		imageString += "0001001001001001";
		imageString += "0001000000001001";
		imageString += "0000100000000001";
		imageString += "0001100000000010";
		imageString += "0010000000000010";
		imageString += "0010000000000010";
		imageString += "0010000000000100";
		imageString += "0001000000000100";
		imageString += "0000100000001000";
		imageString += "0000010000001000";
		imageString += "0000010000001000";

		String maskString = "";
		maskString += "0000000000000000";
		maskString += "0000000000110000";
		maskString += "0000000001111000";
		maskString += "0000000001111010";
		maskString += "0000110111111111";
		maskString += "0001111111111111";
		maskString += "0001111111111111";
		maskString += "0000111111111111";
		maskString += "0001111111111110";
		maskString += "0011111111111110";
		maskString += "0011111111111110";
		maskString += "0011111111111100";
		maskString += "0001111111111100";
		maskString += "0000111111111000";
		maskString += "0000011111111000";
		maskString += "0000011111111000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 7), "hand3");
	}

	/**
	 * Answer the hand cursor #4.
	 * 
	 * @return java.awt.Cursor
	 * @category Hand cursors
	 */
	protected static Cursor HandCursor4() {
		String imageString = "";
		imageString += "0000000000000000";
		imageString += "0000000000000000";
		imageString += "0000000000000000";
		imageString += "0000000000000010";
		imageString += "0000110110110101";
		imageString += "0001001001001001";
		imageString += "0001000000001001";
		imageString += "0000100000000001";
		imageString += "0001100000000010";
		imageString += "0010000000000010";
		imageString += "0010000000000010";
		imageString += "0010000000000100";
		imageString += "0001000000000100";
		imageString += "0000100000001000";
		imageString += "0000010000001000";
		imageString += "0000010000001000";

		String maskString = "";
		maskString += "0000000000000000";
		maskString += "0000000000000000";
		maskString += "0000000000000000";
		maskString += "0000000000000010";
		maskString += "0000110110110111";
		maskString += "0001111111111111";
		maskString += "0001111111111111";
		maskString += "0000111111111111";
		maskString += "0001111111111110";
		maskString += "0011111111111110";
		maskString += "0011111111111110";
		maskString += "0011111111111100";
		maskString += "0001111111111100";
		maskString += "0000111111111000";
		maskString += "0000011111111000";
		maskString += "0000011111111000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 7), "hand4");
	}

	/**
	 * Answer the hand cursor #5.
	 * 
	 * @return java.awt.Cursor
	 * @category Hand cursors
	 */
	protected static Cursor HandCursor5() {
		String imageString = "";
		imageString += "0000000000000000";
		imageString += "0000000000000000";
		imageString += "0000000000000000";
		imageString += "0000000000000000";
		imageString += "0000110110110000";
		imageString += "0001001001001100";
		imageString += "0001000000001010";
		imageString += "0000100000000010";
		imageString += "0001100000000010";
		imageString += "0010000000000010";
		imageString += "0010000000000010";
		imageString += "0010000000000100";
		imageString += "0001000000000100";
		imageString += "0000100000001000";
		imageString += "0000010000001000";
		imageString += "0000010000001000";

		String maskString = "";
		maskString += "0000000000000000";
		maskString += "0000000000000000";
		maskString += "0000000000000000";
		maskString += "0000000000000000";
		maskString += "0000110110110000";
		maskString += "0001111111111100";
		maskString += "0001111111111110";
		maskString += "0000111111111110";
		maskString += "0001111111111110";
		maskString += "0011111111111110";
		maskString += "0011111111111110";
		maskString += "0011111111111100";
		maskString += "0001111111111100";
		maskString += "0000111111111000";
		maskString += "0000011111111000";
		maskString += "0000011111111000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 7), "hand5");
	}

	/**
	 * Answer the stopwacth cursor #0.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	protected static Cursor StopwatchCursor0() {
		String imageString = "";
		imageString += "0000000000000000";
		imageString += "0000011111000000";
		imageString += "0000011111000000";
		imageString += "0110000100001100";
		imageString += "0110111111101100";
		imageString += "0011100100111000";
		imageString += "0010000000001000";
		imageString += "0110000100001100";
		imageString += "0100000100000100";
		imageString += "0110000100001100";
		imageString += "0100000000000100";
		imageString += "0110000000001100";
		imageString += "0010000000001000";
		imageString += "0011100100111000";
		imageString += "0000111111100000";
		imageString += "0000000000000000";

		String maskString = "";
		maskString += "0000011111000000";
		maskString += "0000111111100000";
		maskString += "0110111111101100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "0011111111111000";
		maskString += "0000111111100000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 9), "stopwatch0");
	}

	/**
	 * Answer the stopwacth cursor #1.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	protected static Cursor StopwatchCursor1() {
		String imageString = "";
		imageString += "0000000000000000";
		imageString += "0000011111000000";
		imageString += "0000011111000000";
		imageString += "0110000100001100";
		imageString += "0110111111101100";
		imageString += "0011100100111000";
		imageString += "0010000000001000";
		imageString += "0110000001001100";
		imageString += "0100000010000100";
		imageString += "0110000100001100";
		imageString += "0100000000000100";
		imageString += "0110000000001100";
		imageString += "0010000000001000";
		imageString += "0011100100111000";
		imageString += "0000111111100000";
		imageString += "0000000000000000";

		String maskString = "";
		maskString += "0000011111000000";
		maskString += "0000111111100000";
		maskString += "0110111111101100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "0011111111111000";
		maskString += "0000111111100000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 9), "stopwatch1");
	}

	/**
	 * Answer the stopwacth cursor #2.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	protected static Cursor StopwatchCursor2() {
		String imageString = "";
		imageString += "0000000000000000";
		imageString += "0000011111000000";
		imageString += "0000011111000000";
		imageString += "0110000100001100";
		imageString += "0110111111101100";
		imageString += "0011100100111000";
		imageString += "0010000000001000";
		imageString += "0110000000001100";
		imageString += "0100000000000100";
		imageString += "0110000111101100";
		imageString += "0100000000000100";
		imageString += "0110000000001100";
		imageString += "0010000000001000";
		imageString += "0011100100111000";
		imageString += "0000111111100000";
		imageString += "0000000000000000";

		String maskString = "";
		maskString += "0000011111000000";
		maskString += "0000111111100000";
		maskString += "0110111111101100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "0011111111111000";
		maskString += "0000111111100000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 9), "stopwatch2");
	}

	/**
	 * Answer the stopwacth cursor #3.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	protected static Cursor StopwatchCursor3() {
		String imageString = "";
		imageString += "0000000000000000";
		imageString += "0000011111000000";
		imageString += "0000011111000000";
		imageString += "0110000100001100";
		imageString += "0110111111101100";
		imageString += "0011100100111000";
		imageString += "0010000000001000";
		imageString += "0110000000001100";
		imageString += "0100000000000100";
		imageString += "0110000100001100";
		imageString += "0100000010000100";
		imageString += "0110000001001100";
		imageString += "0010000000001000";
		imageString += "0011100100111000";
		imageString += "0000111111100000";
		imageString += "0000000000000000";

		String maskString = "";
		maskString += "0000011111000000";
		maskString += "0000111111100000";
		maskString += "0110111111101100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "0011111111111000";
		maskString += "0000111111100000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 9), "stopwatch3");
	}

	/**
	 * Answer the stopwacth cursor #4.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	protected static Cursor StopwatchCursor4() {
		String imageString = "";
		imageString += "0000000000000000";
		imageString += "0000011111000000";
		imageString += "0000011111000000";
		imageString += "0110000100001100";
		imageString += "0110111111101100";
		imageString += "0011100100111000";
		imageString += "0010000000001000";
		imageString += "0110000000001100";
		imageString += "0100000000000100";
		imageString += "0110000100001100";
		imageString += "0100000100000100";
		imageString += "0110000100001100";
		imageString += "0010000000001000";
		imageString += "0011100100111000";
		imageString += "0000111111100000";
		imageString += "0000000000000000";

		String maskString = "";
		maskString += "0000011111000000";
		maskString += "0000111111100000";
		maskString += "0110111111101100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "0011111111111000";
		maskString += "0000111111100000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 9), "stopwatch4");
	}

	/**
	 * Answer the stopwacth cursor #5.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	protected static Cursor StopwatchCursor5() {
		String imageString = "";
		imageString += "0000000000000000";
		imageString += "0000011111000000";
		imageString += "0000011111000000";
		imageString += "0110000100001100";
		imageString += "0110111111101100";
		imageString += "0011100100111000";
		imageString += "0010000000001000";
		imageString += "0110000000001100";
		imageString += "0100000000000100";
		imageString += "0110000100001100";
		imageString += "0100001000000100";
		imageString += "0110010000001100";
		imageString += "0010000000001000";
		imageString += "0011100100111000";
		imageString += "0000111111100000";
		imageString += "0000000000000000";

		String maskString = "";
		maskString += "0000011111000000";
		maskString += "0000111111100000";
		maskString += "0110111111101100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "0011111111111000";
		maskString += "0000111111100000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 9), "stopwatch5");
	}

	/**
	 * Answer the stopwacth cursor #6.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	protected static Cursor StopwatchCursor6() {
		String imageString = "";
		imageString += "0000000000000000";
		imageString += "0000011111000000";
		imageString += "0000011111000000";
		imageString += "0110000100001100";
		imageString += "0110111111101100";
		imageString += "0011100100111000";
		imageString += "0010000000001000";
		imageString += "0110000000001100";
		imageString += "0100000000000100";
		imageString += "0110111100001100";
		imageString += "0100000000000100";
		imageString += "0110000000001100";
		imageString += "0010000000001000";
		imageString += "0011100100111000";
		imageString += "0000111111100000";
		imageString += "0000000000000000";

		String maskString = "";
		maskString += "0000011111000000";
		maskString += "0000111111100000";
		maskString += "0110111111101100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "0011111111111000";
		maskString += "0000111111100000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 9), "stopwatch6");
	}

	/**
	 * Answer the stopwacth cursor #7.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	protected static Cursor StopwatchCursor7() {
		String imageString = "";
		imageString += "0000000000000000";
		imageString += "0000011111000000";
		imageString += "0000011111000000";
		imageString += "0110000100001100";
		imageString += "0110111111101100";
		imageString += "0011100100111000";
		imageString += "0010000000001000";
		imageString += "0110010000001100";
		imageString += "0100001000000100";
		imageString += "0110000100001100";
		imageString += "0100000000000100";
		imageString += "0110000000001100";
		imageString += "0010000000001000";
		imageString += "0011100100111000";
		imageString += "0000111111100000";
		imageString += "0000000000000000";

		String maskString = "";
		maskString += "0000011111000000";
		maskString += "0000111111100000";
		maskString += "0110111111101100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "1111111111111110";
		maskString += "0111111111111100";
		maskString += "0111111111111100";
		maskString += "0011111111111000";
		maskString += "0000111111100000";

		return Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(_CreateImage(_Pixels(imageString, maskString))), new Point(7, 9), "stopwatch7");
	}

	/**
	 * Set the new frames.
	 * 
	 * @param newFrames java.awt.Frame[]
	 * @category private
	 */
	public void _frames(Frame[] newFrames) {
		_frames = newFrames;
	}

	/**
	 * Restore the original cursor for all frames.
	 * 
	 * @category showing
	 */
	public void _restore() {
		// Stop the thread for the animation.
		_finished = true;
		try {
			_process.join();
		} catch (InterruptedException e) {
		} finally {
			_process = null;
		}

		// Restore the original cursors.
		if (_savedCursors == null) {
			return;
		}
		Frame[] frames = this._frames();
		for (int i = 0; i < frames.length; i++) {
			frames[i].setCursor(_savedCursors[i]);
		}
		_frames = null;
		_savedCursors = null;
	}

	/**
	 * Set the cursor for all frames.
	 * 
	 * @category showing
	 */
	public void _show() {
		this._show(null);
	}

	/**
	 * Show the cursor animation.
	 *
	 * @param interimBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category showing
	 */
	public void _show(final StBlockClosure interimBlock) {
		// Save the original cursors.
		Frame[] frames = this._frames();
		_savedCursors = new Cursor[frames.length];
		for (int i = 0; i < frames.length; i++) {
			_savedCursors[i] = frames[i].getCursor();
		}

		// Start the thread for the animation.
		_process = new Thread() {
			public void run() {
				int index = 0;
				Cursor[] cursors = cursors();
				while (_finished == false) {
					Thread.yield();

					try {
						_process.sleep(tick());
					} catch (InterruptedException e) {
					}

					if (interimBlock != null) {
						interimBlock.value();
					}

					if (index < cursors.length) {
						Frame[] frames = _frames();
						for (int i = 0; i < frames.length; i++) {
							frames[i].setCursor(cursors[index]);
						}
						index++;
						if (index >= cursors.length) {
							index = 0;
						}
					}
				}
			}
		};
		_process.setPriority(Thread.NORM_PRIORITY);
		_process.start();
	}

	/**
	 * Answer the current cursors.
	 * 
	 * @return java.awt.Cursor[]
	 * @category accessing
	 */
	public Cursor[] cursors() {
		return cursors;
	}

	/**
	 * Set the new cursors.
	 * 
	 * @param newCursors java.awt.Cursor[]
	 * @category accessing
	 */
	public void cursors_(Cursor[] newCursors) {
		cursors = new Cursor[newCursors.length];
		System.arraycopy(newCursors, 0, cursors, 0, newCursors.length);
	}

	/**
	 * Show the animation cursor while executing a block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category animation
	 */
	public Object showWhile_(StBlockClosure aBlock) {
		return this.showWhile_interim_(aBlock, null);
	}

	/**
	 * Show the animation cursor while executing a block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param interimBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category animation
	 */
	public Object showWhile_interim_(StBlockClosure aBlock, StBlockClosure interimBlock) {
		try {
			this._show(interimBlock);
			return aBlock.value();
		} finally {
			this._restore();
		}
	}

	/**
	 * Answer the current tick in milliseconds.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int tick() {
		return tick;
	}

	/**
	 * Set the new tick in milliseconds.
	 * 
	 * @param newTick int
	 * @category accessing
	 */
	public void tick_(int newTick) {
		tick = Math.max(10, Math.min(newTick, 1000));
	}

	/**
	 * Answer the current frames.
	 * 
	 * @return java.awt.Frame[]
	 * @category private
	 */
	protected Frame[] _frames() {
		if (_frames == null) {
			_frames = Frame.getFrames();
		}
		return _frames;
	}
}
