package jp.co.sra.jun.goodies.parameter;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunParameterViewSwing class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/06/02 (by MATSUDA Ryouichi)
 *  @updated   2003/01/16 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunParameterViewSwing.java,v 8.10 2008/02/20 06:32:01 nisinaka Exp $
 */
public class JunParameterViewSwing extends JunAbstractViewJPanel implements JunParameterView {

	protected JLabel label;
	protected JTextField textField;
	protected JScrollBar scrollbar;

	/**
	 * Create a new instance of JunParameterViewSwing and initialize it.
	 *
	 * @param aModel jp.co.sra.jun.goodies.parameter.JunParameterModel
	 */
	public JunParameterViewSwing(JunParameterModel aModel) {
		super(aModel);

		this.updateParameter();
	}

	/**
	 * Invoked when an action occurs.
	 * 
	 * @param e java.event.ActionEvent
	 */
	public void actionPerformed(ActionEvent e) {
		try {
			double value = new Double(e.getActionCommand()).doubleValue();
			this.getParameterModel().parameter().value_(value);
		} catch (NumberFormatException e2) {
		}
	}

	/**
	 * Invoked when the value of the adjustable has changed.
	 * 
	 * @param e java.event.ActionEvent
	 */
	public void adjustmentValueChanged(AdjustmentEvent e) {
		this.getParameterModel().parameter()._setRangeValue(e.getValue());
	}

	/**
	 * Answer my model as JunParameterModel.
	 * 
	 * @return jp.co.sra.jun.goodies.parameter.JunParameterModel
	 */
	public JunParameterModel getParameterModel() {
		return (JunParameterModel) this.model();
	}

	/**
	 * Set the bounds of myself and my components.
	 *
	 * @param x int
	 * @param y int
	 * @param width int
	 * @param height int
	 */
	public void setBounds(int x, int y, int width, int height) {
		super.setBounds(x, y, width, height);
		this._layoutComponents(width, height);
	}

	/**
	 * Update the view to reflect the changed value.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (evt.getAspect() == $("value")) {
			this.updateParameter();
		} else {
			super.update_(evt);
		}
	}

	/**
	 * Update parameter.
	 */
	public void updateParameter() {
		scrollbar.removeAdjustmentListener(this);
		textField.removeActionListener(this);
		try {
			JunParameter parameter = this.getParameterModel().parameter();
			textField.setText(String.valueOf(parameter.value()));
			scrollbar.setValues(parameter._rangeValue(), 0, parameter._rangeStartValue(), parameter._rangeStopValue());
		} finally {
			textField.addActionListener(this);
			scrollbar.addAdjustmentListener(this);
		}
	}

	/**
	 * Layout my components.
	 *
	 * @param width int
	 * @param height int
	 */
	protected void _layoutComponents(int width, int height) {
		int fontHeight = this.getFontMetrics(label.getFont()).getHeight();
		label.setBounds(1, height / 2 - (fontHeight / 2), (int) (width * 0.4) - 4, fontHeight);
		textField.setBounds((int) (width * 0.4) + 1, 1, (int) (width * 0.6) - 2, 23);
		scrollbar.setBounds((int) (width * 0.4) + 1, 26, (int) (width * 0.6) - 2, height - 27);
	}

	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		label = new JLabel(this.getParameterModel().labelString());
		label.setFont(new Font("dialog", Font.BOLD, 12));
		textField = new JTextField();
		scrollbar = new JScrollBar(Scrollbar.HORIZONTAL);

		this.setLayout(null);
		this.add(label);
		this.add(textField);
		this.add(scrollbar);
		this.setPreferredSize(new Dimension(200, 40));
	}

	/**
	 * Answer a default model.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new JunParameterModel(new JunParameter("parameter", 10));
	}
}
