package jp.co.sra.jun.goodies.parameter;

import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.system.framework.JunApplicationModel;

/**
 * JunParameterModel class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/12/09 (by MATSUDA Ryouichi)
 *  @updated   2003/01/16 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunParameterModel.java,v 8.11 2008/02/20 06:32:01 nisinaka Exp $
 */
public class JunParameterModel extends JunApplicationModel {

	protected JunParameter parameter;
	protected String parameterName;

	/**
	 * Create a new instance of <code>JunParameterModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunParameterModel() {
		super();
	}

	/**
	 * Create a new instance of <code>JunParameterModel</code> and initialize it.
	 * 
	 * @param aParameter jp.co.sra.jun.goodies.parameter.JunParameter
	 * @category Instance creation
	 */
	public JunParameterModel(JunParameter aParameter) {
		this();
		this.parameter_(aParameter);
	}

	/**
	 * Create a new instance of JunParameterModel and set a Parameter.
	 * 
	 * @return jp.co.sra.jun.goodies.parameter.JunParameterModel
	 * @param aParameter jp.co.sra.jun.goodies.parameter.JunParameter
	 * @deprecated since Jun366, use the constructor.
	 * @category Instance creation
	 */
	public static JunParameterModel On_(JunParameter aParameter) {
		return new JunParameterModel(aParameter);
	}

	/**
	 * Create a new instance of JunParameterModel and set a Parameter and open it.
	 * 
	 * @return jp.co.sra.jun.goodies.parameter.JunParameterModel
	 * @param aParameter jp.co.sra.jun.goodies.parameter.JunParameter
	 * @category Instance creation
	 */
	public static JunParameterModel OpenOnParameter_(JunParameter aParameter) {
		JunParameterModel aParameterModel = new JunParameterModel(aParameter);
		aParameterModel.open();
		return aParameterModel;
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunParameterViewAwt(this);
		} else {
			return new JunParameterViewSwing(this);
		}
	}

	/**
	 * Answer a label string.
	 * 
	 * @return java.lang.String
	 * @category aspects
	 */
	public String labelString() {
		return this.parameterName() + " : ";
	}

	/**
	 * Answer the parameter.
	 * 
	 * @return jp.co.sra.jun.goodies.parameter.JunParameter
	 * @category accessing
	 */
	public JunParameter parameter() {
		if (parameter == null) {
			parameter = new JunParameter("parameter");
			parameter.addDependent_(this);
		}

		return parameter;
	}

	/**
	 * Set the parameter.
	 * 
	 * @param aParameter jp.co.sra.jun.goodies.parameter.JunParameter
	 * @category accessing
	 */
	public void parameter_(JunParameter aParameter) {
		if (parameter != null) {
			parameter.removeDependent_(this);
		}
		parameter = aParameter;
		if (parameter != null) {
			parameter.addDependent_(this);
		}
		this.updateParameter();
	}

	/**
	 * Answer the parameter name.
	 * 
	 * @return java.lang.String
	 * @category accessing
	 */
	public String parameterName() {
		if (parameterName != null) {
			return parameterName;
		} else {
			return this.parameter().parameterName();
		}
	}

	/**
	 * Set the parameter name.
	 * 
	 * @param aString java.lang.String
	 * @category accessing
	 */
	public void parameterName_(String aString) {
		parameterName = aString;
	}

	/**
	 * Answer my preferred height.
	 *
	 * @return int
	 * @category accessing
	 */
	public int preferredHeight() {
		return 40;
	}

	/**
	 * Action for the update notification.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.StObject#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (evt.getAspect() == $("value")) {
			this.changed_($("value"));
		}
	}

	/**
	 * Initialize this object.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		parameter = null;
		parameterName = null;
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Parameter Model");
	}

	/**
	 * Notify that my parameter is changed.
	 * 
	 * @category updating
	 */
	protected void updateParameter() {
	}
}
