package jp.co.sra.jun.goodies.nib;

import java.awt.Button;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jp.co.sra.smalltalk.StSimpleDialogViewAwt;
import jp.co.sra.smalltalk.StViewPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunNibChoiceDialogViewAwt class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2004/03/23 (By Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun492 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNibChoiceDialogViewAwt.java,v 8.10 2008/02/20 06:31:51 nisinaka Exp $
 */
public class JunNibChoiceDialogViewAwt extends StSimpleDialogViewAwt implements JunNibChoiceDialogView {

	protected StViewPanel nibChoiceView;
	protected Button acceptButton;
	protected Button cancelButton;

	/**
	 * Create a new instance of JunNibChoiceDialogViewAwt and initialize it with the JunNibChoiceDialog.
	 * 
	 * @param newNibChoiceDialog jp.co.sra.jun.goodies.colors.JunNibChoiceDialog
	 * @category Instance creation
	 */
	public JunNibChoiceDialogViewAwt(JunNibChoiceDialog newNibChoiceDialog) {
		super(newNibChoiceDialog);
	}

	/**
	 * Initialize.
	 * 
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		nibChoiceView = null;
		acceptButton = null;
		cancelButton = null;
	}

	/**
	 * Answer my model as a JunNibChoiceDialog.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunNibChoiceDialog
	 * @category model accessing
	 */
	public JunNibChoiceDialog getNibChoiceDialog() {
		return (JunNibChoiceDialog) this.model();
	}

	/**
	 * Build this component.
	 * 
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.nibChoiceView(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, -50));
		this.add(this.acceptButton(), WindowSpecLayout.Position(0.25f, -44, 1f, -40, 0.25f, 44, 1f, -8));
		this.add(this.cancelButton(), WindowSpecLayout.Position(0.75f, -44, 1f, -40, 0.75f, 44, 1f, -8));
		this.setSize(238, 100);

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer my accpet button.
	 *
	 * @return java.awt.Button
	 * @category interface opening
	 */
	protected Button acceptButton() {
		if (acceptButton == null) {
			acceptButton = new Button(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getNibChoiceDialog().acceptButtonPressed()) {
						getNibChoiceDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return java.awt.Button
	 * @category interface opening
	 */
	protected Button cancelButton() {
		if (cancelButton == null) {
			cancelButton = new Button(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getNibChoiceDialog().cancelButtonPressed()) {
						getNibChoiceDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Answer my nib choice view.
	 *
	 * @return jp.co.sra.smalltalk.StViewPanel
	 * @category interface opening
	 */
	protected StViewPanel nibChoiceView() {
		if (nibChoiceView == null) {
			nibChoiceView = (StViewPanel) JunNibChoiceViewAwt.WithSlider(this.getNibChoiceDialog().nibChoiceModel());
		}
		return nibChoiceView;
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard 
	 */
	public void _setupKeyboard(Window aWindow) {
		this.nibChoiceView()._setupKeyboard(aWindow);
	}

}
