package jp.co.sra.jun.goodies.multimedia;

import java.awt.Window;

import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.files.JunFileViewAwt;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunMultiMediaViewerViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2003/03/18 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun526 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaViewerViewAwt.java,v 8.10 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunMultiMediaViewerViewAwt extends JunAbstractViewPanel implements JunMultiMediaViewerView {

	protected JunFileViewAwt fileView;
	protected JunMultiMediaImageViewAwt imageView;
	protected JunMultiMediaMovieViewAwt movieView;
	protected JunMultiMediaTextViewAwt textView;
	protected JunMultiMediaExtraViewAwt extraView;

	/**
	 * Create a new instance of JunMultiMediaViewerViewAwt and initialize it.
	 *
	 * @param aMultiMediaViewer jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewer
	 * @category Instance creation
	 */
	public JunMultiMediaViewerViewAwt(JunMultiMediaViewer aMultiMediaViewer) {
		super(aMultiMediaViewer);
	}

	/**
	 * Build this component.
	 * 
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fileView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0f, 290));
		this.add(this.imageView(), WindowSpecLayout.Position(0f, 8, 0f, 300, 1f, -8, 1f, -8));
		this.add(this.movieView(), WindowSpecLayout.Position(0f, 8, 0f, 300, 1f, -8, 1f, -8));
		this.add(this.textView(), WindowSpecLayout.Position(0f, 8, 0f, 300, 1f, -8, 1f, -8));
		this.add(this.extraView(), WindowSpecLayout.Position(0f, 8, 0f, 300, 1f, -8, 1f, -8));
		this.setSize(480, 580);
	}

	/**
	 * Answer my model as JunMultiMediaViewer.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewer
	 * @category model accessing
	 */
	public JunMultiMediaViewer getMultiMediaViewer() {
		return (JunMultiMediaViewer) this.model();
	}

	/**
	 * Answer my file view.
	 *
	 * @return jp.co.sra.jun.goodies.files.JunFileViewAwt
	 * @category user interface
	 */
	public JunFileViewAwt fileView() {
		if (fileView == null) {
			fileView = new JunFileViewAwt(this.getMultiMediaViewer().fileModel());
		}
		return fileView;
	}

	/**
	 * Answer my image view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaImageViewAwt
	 * @category user interface
	 */
	public JunMultiMediaImageViewAwt imageView() {
		if (imageView == null) {
			imageView = new JunMultiMediaImageViewAwt(this.getMultiMediaViewer().imageModel());
			imageView.setVisible(false);
		}
		return imageView;
	}

	/**
	 * Answer my movie view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaMovieViewAwt
	 * @category user interface
	 */
	public JunMultiMediaMovieViewAwt movieView() {
		if (movieView == null) {
			movieView = new JunMultiMediaMovieViewAwt(this.getMultiMediaViewer().movieModel());
			movieView.setVisible(false);
		}
		return movieView;
	}

	/**
	 * Answer my text view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextViewAwt
	 * @category user interface
	 */
	public JunMultiMediaTextViewAwt textView() {
		if (textView == null) {
			textView = new JunMultiMediaTextViewAwt(this.getMultiMediaViewer().textModel());
			textView.setVisible(false);
		}
		return textView;
	}

	/**
	 * Answer my extra view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaExtraViewAwt
	 * @category user interface
	 */
	public JunMultiMediaExtraViewAwt extraView() {
		if (extraView == null) {
			extraView = new JunMultiMediaExtraViewAwt(this.getMultiMediaViewer().extraModel());
			extraView.setVisible(false);
		}
		return extraView;
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(Window aWindow) {
		this.movieView().getMovieView()._setupKeyboard(aWindow);
	}

}
