package jp.co.sra.jun.goodies.multimedia;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunMultiMediaTextViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2003/03/19 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaTextViewSwing.java,v 8.12 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunMultiMediaTextViewSwing extends JunAbstractViewJPanel implements JunMultiMediaTextView {

	protected JTextArea textArea;

	/**
	 * Create a new instance of <code>JunMultiMediaTextViewSwing</code> and initialize it.
	 *
	 * @param aMultiMediaTextModel jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextModel
	 * @category Instance creation
	 */
	public JunMultiMediaTextViewSwing(JunMultiMediaTextModel aMultiMediaTextModel) {
		super(aMultiMediaTextModel);
	}

	/**
	 * Answer my model as JunMultiMediaTextModel.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextModel
	 * @see jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextView#getTextModel()
	 * @category model accessing
	 */
	public JunMultiMediaTextModel getTextModel() {
		return (JunMultiMediaTextModel) this.model();
	}

	/**
	 * Answer my text area.
	 *
	 * @return javax.swing.JTextArea
	 * @category user interface
	 */
	public JTextArea textArea() {
		if (textArea == null) {
			textArea = new JTextArea((String) this.getTextModel().textHolder().value());
			textArea.setFont(new Font("monospaced", Font.PLAIN, 12));
			textArea.setEditable(false);
			textArea.setBackground(Color.white);

			this.getTextModel().textHolder().compute_(new StBlockClosure() {
				public Object value_(Object newValue) {
					textArea.setText((String) newValue);
					textArea.setCaretPosition(0);
					return null;
				}
			});
		}
		return textArea;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new BorderLayout());
		this.add(new JScrollPane(this.textArea()), BorderLayout.CENTER);
		this.setPreferredSize(new Dimension(200, 150));
	}

}
