package jp.co.sra.jun.goodies.multimedia;

import java.awt.Dimension;
import java.io.File;

import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer;
import jp.co.sra.jun.goodies.movie.framework.JunMovieView;

/**
 * JunMultiMediaMovieModel class
 * 
 *  @author    nisinaka
 *  @created   2003/03/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun523 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaMovieModel.java,v 8.11 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunMultiMediaMovieModel extends JunMoviePlayer implements JunMultiMediaViewable {

	/**
	 * Create a new instance of <code>JunMultiMediaMovieModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunMultiMediaMovieModel() {
		super();
	}

	/**
	 * Create a new instance of <code>JunMultiMediaMovieModel</code> and initialize it.
	 * 
	 * @param aFile java.io.File
	 * @category Instance creation
	 */
	public JunMultiMediaMovieModel(File aFile) {
		super(aFile);
	}

	/**
	 * Make be invisible.
	 * 
	 * @see jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewable#beInvisible()
	 * @category accessing
	 */
	public void beInvisible() {
		if (this.isPlay()) {
			this.stop();
		}
		if (this.hasMovie()) {
			this.releaseMovieHandle();
		}

		Object[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunMultiMediaMovieView) {
				((JunMultiMediaMovieView) dependents[i]).toComponent().setVisible(false);
			}
		}
	}

	/**
	 * Make be visible.
	 * 
	 * @see jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewable#beVisible()
	 * @category accessing
	 */
	public void beVisible() {
		Object[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunMultiMediaMovieView) {
				JunMultiMediaMovieView aView = (JunMultiMediaMovieView) dependents[i];
				aView.setMovieView();
				aView.toComponent().setVisible(true);
			}
		}
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunMultiMediaMovieViewAwt(this);
		} else {
			return new JunMultiMediaMovieViewSwing(this);
		}
	}

	/**
	 * Hide the tracker.
	 * 
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer#hideTracker()
	 * @category menu messages
	 */
	public void hideTracker() {
		if (this.isEmbedded()) {
			return;
		}

		super.hideTracker();
	}

	/**
	 * Answer true if a view of the image model is embedded, otherwise false.
	 *
	 * @return boolean
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer#isEmbedded()
	 * @category testing
	 */
	public boolean isEmbedded() {
		return this.builder().windows().length == 0;
	}

	/**
	 * Show the tracker.
	 * 
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer#showTracker()
	 * @category menu messages
	 */
	public void showTracker() {
		if (this.isEmbedded()) {
			return;
		}

		super.showTracker();
	}

	/**
	 * Answer one of the movie views.
	 * Override the method of JunMoviePlayer since JunMultiMediaMovieView is a Panel that contains the real movie view.
	 * 
	 * @return jp.co.sra.jun.goodies.movie.framework.JunMovieView
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer#getMovieView()
	 * @category private
	 */
	protected JunMovieView getMovieView() {
		JunMultiMediaMovieView aView = this.getMultiMediaMovieView();
		return (aView == null) ? null : aView.getMovieView();
	}

	/**
	 * Answer one of the multi media movie views.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaMovieView
	 * @category view accessing
	 */
	protected JunMultiMediaMovieView getMultiMediaMovieView() {
		Object[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunMultiMediaMovieView) {
				return (JunMultiMediaMovieView) dependents[i];
			}
		}

		return null;
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		this.trackerModel().enableMarkers();
	}

	/**
	 * Set the size for the view.
	 * 
	 * @param extent java.awt.Dimension
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer#setSize_(java.awt.Dimension)
	 * @category private
	 */
	protected void setSize_(Dimension extent) {
		if (this.isEmbedded()) {
			if (this.hasMovie() == false) {
				return;
			}
			JunMovieView aView = this.getMovieView();
			if (aView == null) {
				return;
			}
			aView.setMovieView();
			return;
		}

		super.setSize_(extent);
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		if (this.hasMovie()) {
			if (this.isSound()) {
				return $String("Sound");
			}
		}
		return $String("Movie");
	}
}
