package jp.co.sra.jun.goodies.meter;

import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunStereoLevelMeter class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/04/04 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun652 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunStereoLevelMeter.java,v 8.6 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunStereoLevelMeter extends JunAbstractGaugeMeter {
	protected JunAbstractGaugeMeter leftMeter;
	protected JunAbstractGaugeMeter rightMeter;

	/**
	 * Create a new instance of <code>JunStereoLevelMeter</code> and initialize it.
	 * 
	 * @param numberOfGauges int
	 * @category Instance creation
	 */
	public JunStereoLevelMeter(int numberOfGauges) {
		super(numberOfGauges);
	}

	/**
	 * Create a new instance of <code>JunStereoLevelMeter</code> and initialize it.
	 * 
	 * @param numberOfGauges int
	 * @param value double
	 * @param maximum double
	 * @param minimum double
	 * @category Instance creation
	 */
	public JunStereoLevelMeter(int numberOfGauges, double value, double maximum, double minimum) {
		super(numberOfGauges, value, maximum, minimum);
	}

	/**
	 * Create a new instance of <code>JunStereoLevelMeter</code> and initialize it.
	 * 
	 * @param numberOfGauges int
	 * @param valueCollection double[]
	 * @param maximumCollection double[]
	 * @param minimumCollection double[]
	 * @category Instance creation
	 */
	public JunStereoLevelMeter(int numberOfGauges, double[] valueCollection, double[] maximumCollection, double[] minimumCollection) {
		super(numberOfGauges, valueCollection, maximumCollection, minimumCollection);
	}

	/**
	 * Initialize the receiver with the specified values.
	 * 
	 * @param numberOfGauges int
	 * @param valueCollection double[]
	 * @param maximumCollection double[]
	 * @param minimumCollection double[]
	 * @see jp.co.sra.jun.goodies.meter.JunAbstractGaugeMeter#initialize_values_maximumx_minimums_(int, double[], double[], double[])
	 * @category initialize-release
	 */
	protected void initialize_values_maximumx_minimums_(int numberOfGauges, double[] valueCollection, double[] maximumCollection, double[] minimumCollection) {
		Object[] arguments = new Object[] { new Integer(numberOfGauges), valueCollection, maximumCollection, minimumCollection };
		leftMeter = (JunLevelGaugeMeter) _New(this.defaultLevelGaugeMeterClass(), arguments);
		arguments = new Object[] { new Integer(numberOfGauges), valueCollection, maximumCollection, minimumCollection };
		rightMeter = (JunLevelGaugeMeter) _New(this.defaultLevelGaugeMeterClass(), arguments);
	}

	/**
	 * Answer the receiver's gauges
	 * 
	 * @return jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel[]
	 * @see jp.co.sra.jun.goodies.meter.JunAbstractGaugeMeter#gauges()
	 * @category accessing
	 */
	public JunLevelGaugeModel[] gauges() {
		JunLevelGaugeModel[] leftGauges = this.leftGauges();
		JunLevelGaugeModel[] rightGauges = this.rightGauges();
		JunLevelGaugeModel[] gauges = new JunLevelGaugeModel[leftGauges.length + rightGauges.length];
		for (int i = 0; i < leftGauges.length; i++) {
			gauges[i] = leftGauges[i];
		}
		for (int i = 0; i < rightGauges.length; i++) {
			gauges[i + leftGauges.length] = rightGauges[i];
		}

		return gauges;
	}

	/**
	 * Answer the receiver's left meter.
	 * 
	 * @return jp.co.sra.jun.goodies.meter.JunAbstractGaugeMeter
	 * @category accessing
	 */
	public JunAbstractGaugeMeter leftMeter() {
		return leftMeter;
	}

	/**
	 * Answer the receiver's left gauges.
	 * 
	 * @return jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel[]
	 * @category accessing
	 */
	public JunLevelGaugeModel[] leftGauges() {
		return this.leftMeter().gauges();
	}

	/**
	 * Answer the receiver's left values.
	 * 
	 * @return double[]
	 * @category accessing
	 */
	public double[] leftValues() {
		return this.leftMeter().values();
	}

	/**
	 * Set the receiver's left values.
	 * 
	 * @param valueCollection double[]
	 * @category accessing
	 */
	public void leftValues_(double[] valueCollection) {
		this.leftMeter().values_(valueCollection);
	}

	/**
	 * Set the receiver's left values.
	 * 
	 * @param valueCollection java.lang.Number[]
	 * @category accessing
	 */
	public void leftValues_(Number[] valueCollection) {
		this.leftMeter().values_(valueCollection);
	}

	/**
	 * Answer the receiver's right meter.
	 * 
	 * @return jp.co.sra.jun.goodies.meter.JunAbstractGaugeMeter
	 * @category accessing
	 */
	public JunAbstractGaugeMeter rightMeter() {
		return rightMeter;
	}

	/**
	 * Answer the receiver's right gauges.
	 * 
	 * @return jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel[]
	 * @category accessing
	 */
	public JunLevelGaugeModel[] rightGauges() {
		return this.rightMeter().gauges();
	}

	/**
	 * Answer the receiver's right values.
	 * 
	 * @return double[]
	 * @category accessing
	 */
	public double[] rightValues() {
		return this.rightMeter().values();
	}

	/**
	 * Set the receiver's right values.
	 * 
	 * @param valueCollection double[]
	 * @category accessing
	 */
	public void rightValues_(double[] valueCollection) {
		this.rightMeter().values_(valueCollection);
	}

	/**
	 * Set the receiver's right values.
	 * 
	 * @param valueCollection java.lang.Number[]
	 * @category accessing
	 */
	public void rightValues_(Number[] valueCollection) {
		this.rightMeter().values_(valueCollection);
	}

	/**
	 * Answer the receiver's default level gauge meter class.
	 * 
	 * @return java.lang.Class
	 * @category defaults
	 */
	public Class defaultLevelGaugeMeterClass() {
		return JunLevelGaugeMeter.class;
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunStereoLevelMeterViewAwt(this);
		} else {
			return new JunStereoLevelMeterViewSwing(this);
		}
	}

	/**
	 * Answer a window title.
	 *
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Stereo Level Meter");
	}
}
