package jp.co.sra.jun.goodies.lisp;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Vector;

import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;

/**
 * JunLispList class
 * 
 *  @author    ASTI Beijing
 *  @created   1998/12/09 (by ASTI Beijing)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun346 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLispList.java,v 8.10 2008/02/20 06:31:49 nisinaka Exp $
 */
public abstract class JunLispList extends StObject {

	/**
	 * Create a new instance of JunLispCons.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category Instance creation
	 */
	public static JunLispCons Cell() {
		return JunLispCons.Cell();
	}

	/**
	 * Create a new instance of JunLispList.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param head java.lang.Object
	 * @category Instance creation 
	 */
	public static JunLispList Head_(Object head) {
		return JunLispCons.Head_(head);
	}

	/**
	 * Create a new instance of JunLispList.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param head java.lang.Object
	 * @param tail java.lang.Object
	 * @category Instance creation 
	 */
	public static JunLispList Head_tail_(Object head, Object tail) {
		return JunLispCons.Head_tail_(head, tail);
	}

	/**
	 * Create a new list and initialize it with an array of Object.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param anArray java.lang.Object[]
	 * @category Instance creation 
	 */
	public static JunLispList List_(Object[] anArray) {
		JunLispList list = NullList();
		for (int i = anArray.length - 1; i >= 0; i--) {
			list = Head_tail_(anArray[i], list);
		}
		return list;
	}

	/**
	 * Create a new list and initialize it with an array of Object.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param aCollection java.util.Collection
	 * @category Instance creation 
	 */
	public static JunLispList List_(Collection aCollection) {
		return List_(aCollection.toArray());
	}

	/**
	 * Create a new list with specified numbers of null nodes.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param number int
	 * @category Instance creation 
	 */
	public static JunLispList New_(int number) {
		JunLispList newList = NullList();
		for (int i = 0; i < number; i++) {
			newList = Head_tail_(NullList(), newList);
		}
		return newList;
	}

	/**
	 * Answer the cell which represents a null list.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispNil
	 * @category Instance creation
	 */
	public static JunLispNil NullList() {
		return JunLispNil.NullList();
	}

	/**
	 * Create a new list and initialize it with an object.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param anObject java.lang.Object
	 * @category Instance creation 
	 */
	public static JunLispList With_(Object anObject) {
		return Head_(anObject);
	}

	/**
	 * Create a new list and initialize it with two objects.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param firstObject java.lang.Object
	 * @param secondObject java.lang.Object
	 * @category Instance creation 
	 */
	public static JunLispList With_with_(Object firstObject, Object secondObject) {
		return Head_tail_(firstObject, With_(secondObject));
	}

	/**
	 * Create a new list and initialize it with three objects.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param firstObject java.lang.Object
	 * @param secondObject java.lang.Object
	 * @param thirdObject java.lang.Object
	 * @category Instance creation 
	 */
	public static JunLispList With_with_with_(Object firstObject, Object secondObject, Object thirdObject) {
		return Head_tail_(firstObject, With_with_(secondObject, thirdObject));
	}

	/**
	 * Create a new list and initialize it with four objects.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param firstObject java.lang.Object
	 * @param secondObject java.lang.Object
	 * @param thirdObject java.lang.Object
	 * @param fourthObject java.lang.Object
	 * @category Instance creation 
	 */
	public static JunLispList With_with_with_with_(Object firstObject, Object secondObject, Object thirdObject, Object fourthObject) {
		return Head_tail_(firstObject, With_with_with_(secondObject, thirdObject, fourthObject));
	}

	/**
	 * Convert the receiver as an array of Object.
	 * 
	 * @return java.lang.Object[]
	 * @category converting
	 */
	public abstract Object[] asArray();

	/**
	 * Put the object at the specified place.
	 * 
	 * @param indexInteger int
	 * @param anObject java.lang.Object
	 * @category accessing
	 */
	public void at_put_(int indexInteger, Object anObject) {
		this.subscriptOutOfBoundsError_(indexInteger);
	}

	/**
	 * Evaluate the Block with each of the receiver's elements and answer the
	 * first element for which the Block evaluates to true.
	 * 
	 * @return java.lang.Object
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param exceptionBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating 
	 */
	public abstract Object detect_ifNone_(StBlockClosure aBlock, StBlockClosure exceptionBlock);

	/**
	 * Enumerate all elements of the receiver and evaluate the StBlockClosure.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating
	 */
	public abstract void do_(StBlockClosure aBlock);

	/**
	 * Enumerate the sublists and return one with the specified head.
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.SySymbol
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category enumerating
	 */
	public abstract JunLispCons _findSublistWithHead(StSymbol aSymbol);

	/**
	 * Answer the receiver as for a head object.
	 * 
	 * @return java.lang.Object
	 * @category accessing
	 */
	public abstract Object head();

	/**
	 * Answer true if the receiver is a cons, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isCons() {
		return (this.nullList() == false);
	}

	/**
	 * Answer the length of the receiver.
	 * 
	 * @return int
	 * @category functions
	 */
	public abstract int length();

	/**
	 * Answer true if the receiver is a null list, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean nullList() {
		return false;
	}

	/**
	 * Generate a string for saving the receiver.
	 * 
	 * @param aWriter java.io.Writer
	 * @exception IOException 
	 * @category saving 
	 */
	public abstract void saveOn_(Writer aWriter) throws IOException;

	/**
	 * Generate a string for saving the receiver.
	 * 
	 * @return java.lang.String
	 * @category saving
	 */
	public abstract String saveString();

	/**
	 * Answer the number of elements of the receiver.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int size() {
		final StValueHolder tally = new StValueHolder(0);
		this.do_(new StBlockClosure() {
			public Object value_(Object anObject) {
				tally.value_(tally._intValue() + 1);
				return null;
			}
		});
		return tally._intValue();
	}

	/**
	 * Answer the receiver as for a tail object.
	 * 
	 * @return java.lang.Object
	 * @category accessing
	 */
	public abstract Object tail();

	/**
	 * Convert the receiver as a Vector.
	 * 
	 * @return java.util.Vector
	 * @category converting
	 */
	public abstract Vector toVector();

	/**
	 * Throw a runtime exception for a subscript out of bounds error.
	 * 
	 * @return java.lang.Object
	 * @param index int
	 * @category private 
	 */
	protected Object subscriptOutOfBoundsError_(int index) {
		throw SmalltalkException.Error("subscript out of bounds error: " + index);
	}
}
