package jp.co.sra.jun.goodies.lisp;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Vector;

import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.geometry.basic.JunPoint;

/**
 * JunLispCons class
 * 
 *  @author    ASTI Beijing
 *  @created   1998/12/09 (by ASTI Beijing)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLispCons.java,v 8.10 2008/02/20 06:31:48 nisinaka Exp $
 */
public class JunLispCons extends JunLispList {
	protected static int HorizontalLevel = 50;
	protected static int VerticalLevel = 10;

	protected Object head;
	protected Object tail;

	/**
	 * Create a new instance of JunLispCons.
	 * 
	 * @param headObject java.lang.Object
	 * @param tailObject java.lang.Object
	 * @category Instance creation
	 */
	public JunLispCons(Object headObject, Object tailObject) {
		this.head_tail_(headObject, tailObject);
	}

	/**
	 * Create a new instance of JunLispCons and initialize it.
	 * This constructor can be used instead of <code>(JunLispCons) JunLispList.Head_(headObject)</code>.
	 *
	 * @param headObject java.lang.Object
	 * @category Instance creation
	 */
	public JunLispCons(Object headObject) {
		this(headObject, NullList());
	}

	/**
	 * Create a new instance of JunLispCons and initialize it.
	 * This constructor can be used instead of <code>JunLispCons.Cell()</code>.
	 * 
	 * @category Instance creation
	 */
	public JunLispCons() {
		this(NullList(), NullList());
	}

	/**
	 * Create a new instance of JunLispCons and initialize it with null lists.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category Instance creation
	 */
	public static JunLispCons Cell() {
		return new JunLispCons(NullList(), NullList());
	}

	/**
	 * Create a new instance of JunLispCons and initialize it with a head object.
	 * 
	 * @param headObject java.lang.Object
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	public static JunLispList Head_(Object headObject) {
		return new JunLispCons(headObject, NullList());
	}

	/**
	 * Create a new instance of JunLispCons and initialize it with the head object and the tail object.
	 * 
	 * @param headObject java.lang.Object
	 * @param tailObject java.lang.Object
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	public static JunLispList Head_tail_(Object headObject, Object tailObject) {
		return new JunLispCons(headObject, tailObject);
	}

	/**
	 * Answer the horizontal level of JunLispCons.
	 * 
	 * @return int
	 * @category Level accessing
	 */
	public static int HorizontalLevel() {
		return HorizontalLevel;
	}

	/**
	 * Set the horizontal level of JunLispCons.
	 * 
	 * @param anInteger int
	 * @category Level accessing
	 */
	public static void HorizontalLevel_(int anInteger) {
		HorizontalLevel = anInteger;
	}

	/**
	 * Create a new JunLispCons from the array of Object.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @param anArray byte[]
	 * @category Instance creation
	 */
	public static JunLispList List_(byte[] anArray) {
		JunLispList list = JunLispList.NullList();
		for (int i = anArray.length - 1; i >= 0; i--) {
			list = new JunLispCons(new Byte(anArray[i]), list);
		}
		return list;
	}

	/**
	 * Create a new JunLispCons from the array of Object.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @param anArray double[]
	 * @category Instance creation
	 */
	public static JunLispList List_(double[] anArray) {
		JunLispList list = JunLispList.NullList();
		for (int i = anArray.length - 1; i >= 0; i--) {
			list = new JunLispCons(new Double(anArray[i]), list);
		}
		return list;
	}

	/**
	 * Create a new JunLispCons from the array of Object.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @param anArray float[]
	 * @category Instance creation
	 */
	public static JunLispList List_(float[] anArray) {
		JunLispList list = JunLispList.NullList();
		for (int i = anArray.length - 1; i >= 0; i--) {
			list = new JunLispCons(new Float(anArray[i]), list);
		}
		return list;
	}

	/**
	 * Create a new JunLispCons from the array of Object.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @param anArray int[]
	 * @category Instance creation
	 */
	public static JunLispList List_(int[] anArray) {
		JunLispList list = JunLispList.NullList();
		for (int i = anArray.length - 1; i >= 0; i--) {
			list = new JunLispCons(new Integer(anArray[i]), list);
		}
		return list;
	}

	/**
	 * Create a new JunLispCons from the array of Object.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @param anArray long[]
	 * @category Instance creation
	 */
	public static JunLispList List_(long[] anArray) {
		JunLispList list = JunLispList.NullList();
		for (int i = anArray.length - 1; i >= 0; i--) {
			list = new JunLispCons(new Long(anArray[i]), list);
		}
		return list;
	}

	/**
	 * Create a new JunLispCons from the array of Object.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @param anArray java.lang.Object[]
	 * @category Instance creation
	 */
	public static JunLispList List_(Object[] anArray) {
		JunLispList list = JunLispList.NullList();
		for (int i = anArray.length - 1; i >= 0; i--) {
			list = new JunLispCons(anArray[i], list);
		}
		return list;
	}

	/**
	 * Create a new JunLispCons from the array of Object.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @param anArray short[]
	 * @category Instance creation
	 */
	public static JunLispList List_(short[] anArray) {
		JunLispList list = JunLispList.NullList();
		for (int i = anArray.length - 1; i >= 0; i--) {
			list = new JunLispCons(new Short(anArray[i]), list);
		}
		return list;
	}

	/**
	 * Create a new JunLispCons from the array of Object.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @param anArray boolean[]
	 * @category Instance creation
	 */
	public static JunLispList List_(boolean[] anArray) {
		JunLispList list = JunLispList.NullList();
		for (int i = anArray.length - 1; i >= 0; i--) {
			list = new JunLispCons(new Boolean(anArray[i]), list);
		}
		return list;
	}

	/**
	 * Create a new JunLispCons from the collection of Object.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @param aCollection java.util.Collection
	 * @category Instance creation
	 */
	public static JunLispList List_(Collection aCollection) {
		return JunLispCons.List_(aCollection.toArray());
	}

	/**
	 * Create a new list which has a specified number of NIL.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param anInteger int
	 * @category Instance creation
	 */
	public static JunLispList New_(int anInteger) {
		JunLispList newList = NullList();
		for (int i = 0; i < anInteger; i++) {
			newList = new JunLispCons(NullList(), newList);
		}
		return newList;
	}

	/**
	 * Answer the vertical level of JunLispCons.
	 * 
	 * @return int
	 * @category Level accessing
	 */
	public static int VerticalLevel() {
		return VerticalLevel;
	}

	/**
	 * Set the vertical level of JunLispCons.
	 * 
	 * @param anInteger int
	 * @category Level accessing
	 */
	public static void VerticalLevel_(int anInteger) {
		VerticalLevel = anInteger;
	}

	/**
	 * Add the object to the receiver.
	 * 
	 * @return java.lang.Object
	 * @param newObject java.lang.Object
	 * @category adding
	 */
	public Object add_(Object newObject) {
		this.nconc_(new JunLispCons(newObject, NullList()));
		return this;
	}

	/**
	 * Append the list at the tail of the receiver.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @param list jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category functions
	 */
	public JunLispCons append_(JunLispList list) {
		if (tail instanceof JunLispCons == false) {
			return new JunLispCons(head, list);
		}
		return new JunLispCons(head, ((JunLispCons) tail).append_(list));
	}

	/**
	 * Convert the receiver as an array of Object.
	 * 
	 * @return java.lang.Object[]
	 * @category converting
	 */
	public Object[] asArray() {
		int size = this.length();
		Object[] array = new Object[size];
		Object list = this;
		for (int i = 0; list instanceof JunLispCons; i++) {
			array[i] = ((JunLispCons) list).head();
			list = ((JunLispCons) list).tail();
		}
		return array;
	}

	/**
	 * Answer the object with the specified index.
	 * 
	 * @return java.lang.Object
	 * @param indexInteger int
	 * @category accessing
	 */
	public Object at_(int indexInteger) {
		int count = 1;
		Object cdr = this;
		while (cdr instanceof JunLispCons) {
			if (count == indexInteger) {
				return ((JunLispCons) cdr).head();
			}
			count++;
			cdr = ((JunLispCons) cdr).tail();
		}
		return this.subscriptOutOfBoundsError_(indexInteger);
	}

	/**
	 * Replace the object at the specified index.
	 * 
	 * @param indexInteger int
	 * @param anObject java.lang.Object
	 * @category accessing
	 */
	public void at_put_(int indexInteger, Object anObject) {
		int count = 1;
		Object cdr = this;
		while (cdr instanceof JunLispCons) {
			if (count == indexInteger) {
				((JunLispCons) cdr).head_(anObject);
			}
			count++;
			cdr = ((JunLispCons) cdr).tail();
		}
		this.subscriptOutOfBoundsError_(indexInteger);
	}

	/**
	 * Enumerate all elements of the receiver and collect elements which are
	 * applied the StBlockClosure.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating
	 */
	public JunLispList collect_(StBlockClosure aBlock) {
		Object list = this;
		JunLispList result = NullList();
		while (list instanceof JunLispCons) {
			result = new JunLispCons(aBlock.value_(((JunLispCons) list).head()), result);
			list = ((JunLispCons) list).tail();
		}
		return ((JunLispCons) result).reverse();
	}

	/**
	 * Evaluate the Block with each of the receiver's elements and answer the
	 * first element for which the Block evaluates to true.
	 * 
	 * @return java.lang.Object
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param exceptionBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating
	 */
	public Object detect_ifNone_(StBlockClosure aBlock, StBlockClosure exceptionBlock) {
		Object list = this;
		while (list instanceof JunLispCons) {
			Object car = ((JunLispCons) list).head();
			if (((Boolean) aBlock.value_(car)).booleanValue()) {
				return (JunLispCons) car;
			}

			list = ((JunLispCons) list).tail();
		}

		return exceptionBlock.value();
	}

	/**
	 * Enumerate all elements of the receiver and evaluate the StBlockClosure.
	 * 
	 * @param aBlock
	 * @category enumerating
	 */
	public void do_(StBlockClosure aBlock) {
		Object list = this;
		while (list instanceof JunLispCons) {
			aBlock.value_(((JunLispCons) list).head());
			list = ((JunLispCons) list).tail();
		}
	}

	/**
	 * Enumerate the sublists and return one with the specified head.
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.SySymbol
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @see jp.co.sra.jun.goodies.lisp.JunLispList#_findSublistWithHead(jp.co.sra.smalltalk.StSymbol)
	 * @category enumerating
	 */
	public JunLispCons _findSublistWithHead(final StSymbol aSymbol) {
		if (aSymbol == null) {
			return null;
		}

		return (JunLispCons) this.detect_ifNone_(new StBlockClosure() {
			public Object value_(Object anObject) {
				return new Boolean(anObject instanceof JunLispCons && (((JunLispCons) anObject).head() == aSymbol));
			}
		}, new StBlockClosure());
	}

	/**
	 * Answer true if the object equals to the receiver, otherwise false.
	 * 
	 * @return boolean
	 * @param anObject
	 * @category testing
	 */
	public boolean equals(Object anObject) {
		if (!(anObject instanceof JunLispCons)) {
			return false;
		}

		if (!head.equals(((JunLispCons) anObject).head())) {
			return false;
		} else {
			Object tailObject = this.tail();
			Object objectTail = ((JunLispCons) anObject).tail();

			if (!(tailObject instanceof JunLispList)) {
				return tailObject.equals(objectTail);
			} else if (!(objectTail instanceof JunLispList)) {
				return false; //tailObject instanceof  JunLispList
			} else if (((JunLispList) tailObject).nullList()) {
				return ((JunLispList) objectTail).nullList();
			}
			return (((JunLispCons) tailObject).equals(objectTail));
		}
	}

	/**
	 * Answer the head object of the receiver.
	 * 
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object head() {
		return head;
	}

	/**
	 * Set the head object of the receiver.
	 * 
	 * @param anObject java.lang.Object
	 * @category accessing
	 */
	public void head_(Object anObject) {
		head = anObject;
	}

	/**
	 * Set the head object and the tail object of the receiver.
	 * 
	 * @param headObject java.lang.Object
	 * @param tailObject java.lang.Object
	 * @category accessing
	 */
	public void head_tail_(Object headObject, Object tailObject) {
		this.head_(headObject);
		this.tail_(tailObject);
	}

	/**
	 * Answer the last object of the receiver.
	 * 
	 * @return Object
	 * @category functions
	 */
	public Object last() {
		Object list = new JunLispCons(null, this);
		Object cdr = this;
		while (cdr instanceof JunLispCons) {
			list = ((JunLispCons) list).tail();
			cdr = ((JunLispCons) cdr).tail();
		}
		return list;
	}

	/**
	 * Answer the length of the receiver.
	 * 
	 * @return int
	 * @category functions
	 */
	public int length() {
		int count = 0;
		Object list = this;
		while (list instanceof JunLispCons) {
			count++;
			list = ((JunLispCons) list).tail();
		}
		return count;
	}

	/**
	 * Enumerate all cdr elements and evaluate the StBlockClosure.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category functions
	 */
	public void mapcdr_(StBlockClosure aBlock) {
		Object list = this;
		while (list instanceof JunLispCons) {
			aBlock.value_(list);
			list = ((JunLispCons) list).tail();
		}
	}

	/**
	 * Answer the sublist which has the object as a head object
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param anObject java.lang.Object
	 * @category functions
	 */
	public JunLispList member_(Object anObject) {
		Object list = this;
		while (list instanceof JunLispCons) {
			if (((JunLispCons) list).head().equals(anObject)) {
				return (JunLispList) list;
			}
			list = ((JunLispCons) list).tail();
		}
		return JunLispList.NullList();
	}

	/**
	 * Answer the sublist which has the object as a head object .
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param anObject java.lang.Object
	 * @category functions
	 */
	public JunLispList memq_(Object anObject) {
		Object list = this;
		while (list instanceof JunLispCons) {
			if (((JunLispCons) list).head() == anObject) {
				return (JunLispList) list;
			}
			list = ((JunLispCons) list).tail();
		}
		return JunLispList.NullList();
	}

	/**
	 * Concatinate the list at the tail of the receiver.
	 * 
	 * @param list jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category functions
	 */
	public void nconc_(JunLispList list) {
		((JunLispCons) this.last()).rplacd_(list);
	}

	/**
	 * Answer the n'th object of the receiver.
	 * 
	 * @return java.lang.Object
	 * @param nth int
	 * @category functions
	 */
	public Object nth_(int nth) {
		if (nth <= 0) {
			return JunLispList.NullList();
		}

		int count = 1;
		Object list = this;
		while (list instanceof JunLispCons) {
			if (count >= nth) {
				return ((JunLispCons) list).head();
			}
			count++;
			list = ((JunLispCons) list).tail();
		}
		return JunLispList.NullList();
	}

	/**
	 * Pretty print my string representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @exception IOException The exception description.
	 * @category pretty printing
	 */
	public void ppOn_(Writer aWriter) throws IOException {
		this.ppOn_list_position_(aWriter, this, 0);
		BufferedWriter bw = (aWriter instanceof BufferedWriter) ? (BufferedWriter) aWriter : new BufferedWriter(aWriter);
		bw.newLine();
		bw.flush();
	}

	/**
	 * Pretty print my string representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param list java.lang.Object
	 * @param position int
	 * @exception IOException The exception description.
	 * @category pretty printing
	 */
	public void ppOn_list_position_(Writer aWriter, Object list, int position) throws IOException {
		if ((list instanceof JunLispCons) == false) {
			this.ppOn_object_(aWriter, list);
			return;
		}

		BufferedWriter bw = (aWriter instanceof BufferedWriter) ? (BufferedWriter) aWriter : new BufferedWriter(aWriter);
		JunLispCons cons = (JunLispCons) list;
		if ((cons.head() instanceof JunLispCons) == false) {
			bw.write('(');
			this.ppOn_object_(bw, cons.head());
			if (cons.tail() instanceof JunLispList) {
				this.ppOn_tail_position_(bw, (JunLispList) cons.tail(), position + 1);
			} else {
				bw.write(" . ");
				this.ppOn_object_(bw, cons.tail());
			}
			bw.write(')');
		} else {
			bw.write('(');
			this.ppOn_list_position_(bw, cons.head(), position + 1);
			if (cons.tail() instanceof JunLispCons) {
				if (((JunLispCons) cons.tail()).head() instanceof JunLispCons) {
					bw.newLine();
					this.ppOn_spaceAndTab_(bw, position);
					this.ppOn_tail_position_(bw, (JunLispList) cons.tail(), position);
				} else {
					this.ppOn_space_(bw, 1);
					this.ppOn_tail_position_(bw, (JunLispList) cons.tail(), position + 1);
				}
			} else {
				if ((cons.tail() instanceof JunLispList) == false) {
					bw.write(" . ");
					this.ppOn_object_(bw, (JunLispList) cons.tail());
				}
			}
			bw.write(')');
		}
	}

	/**
	 * Pretty print my string representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param anObject java.lang.Object
	 * @exception IOException The exception description.
	 * @category pretty printing
	 */
	public void ppOn_object_(Writer aWriter, Object anObject) throws IOException {
		if (anObject instanceof Number) {
			aWriter.write(String.valueOf((Number) anObject));
			return;
		} else if (anObject instanceof StSymbol) {
			aWriter.write(anObject.toString());
			return;
		} else if (anObject instanceof String) {
			aWriter.write('"');
			String aString = (String) anObject;
			for (int i = 0; i < aString.length(); i++) {
				char ch = aString.charAt(i);
				if (ch == '"') {
					aWriter.write('\"');
				} else {
					aWriter.write(ch);
				}
			}
			aWriter.write('"');
			return;
		} else if (anObject instanceof JunLispNil) {
			aWriter.write("nil");
			return;
		} else if (anObject instanceof Vector) {
			int size = ((Vector) anObject).size();
			Object[] anArray = new Object[size];
			((Vector) anObject).copyInto(anArray);
			anObject = anArray;
		} else if (anObject instanceof Object[]) {
			Object[] anArray = (Object[]) anObject;
			aWriter.write("(");
			if (anArray.length > 0) {
				this.printOn_object_(aWriter, anArray[0]);
				for (int i = 1; i < anArray.length; i++) {
					aWriter.write(' ');
					this.printOn_object_(aWriter, anArray[i]);
				}
			}
			aWriter.write(")");
			return;
		}

		aWriter.write('{');
		aWriter.write(anObject.toString());
		aWriter.write('}');
	}

	/**
	 * Pretty print the specified number of spaces.
	 * 
	 * @param aWriter java.io.Writer
	 * @param number int
	 * @exception IOException The exception description.
	 * @category pretty printing
	 */
	public void ppOn_space_(Writer aWriter, int number) throws IOException {
		for (int i = 0; i < number; i++) {
			aWriter.write(' ');
		}
	}

	/**
	 * Pretty print the specified number of spaces.
	 * 
	 * @param aWriter java.io.Writer
	 * @param number int
	 * @exception IOException The exception description.
	 * @category pretty printing
	 */
	public void ppOn_spaceAndTab_(Writer aWriter, int number) throws IOException {
		int tabs = number / this.tabStop();
		int spaces = number - (tabs * this.tabStop());
		for (int i = 0; i < (tabs * (this.tabStop() / 4)); i++) {
			aWriter.write('\t');
		}
		for (int i = 0; i < spaces; i++) {
			aWriter.write(' ');
		}
	}

	/**
	 * Pretty print my string representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param list jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param position int
	 * @exception IOException The exception description.
	 * @category pretty printing
	 */
	public void ppOn_tail_position_(Writer aWriter, JunLispList list, int position) throws IOException {
		if (list.nullList()) {
			return;
		}

		BufferedWriter bw = (aWriter instanceof BufferedWriter) ? (BufferedWriter) aWriter : new BufferedWriter(aWriter);
		JunLispCons cons = (JunLispCons) list;
		if (cons.tail() instanceof JunLispList) {
			if (((JunLispList) cons.tail()).nullList()) {
				this.ppOn_space_(bw, 1);
				this.ppOn_list_position_(bw, cons.head(), position + 1);
			} else {
				this.ppOn_space_(bw, 1);
				this.ppOn_list_position_(bw, cons.head(), position + 1);
				bw.newLine();
				this.ppOn_spaceAndTab_(bw, position);
				this.ppOn_tail_position_(bw, (JunLispList) cons.tail(), position);
			}
		} else {
			this.ppOn_space_(bw, 1);
			this.ppOn_list_position_(bw, cons.head(), position + 1);
			bw.write(" . ");
			this.ppOn_object_(bw, (JunLispList) cons.tail());
		}
	}

	/**
	 * Generate the pretty print string of the receiver.
	 * 
	 * @return java.lang.String
	 * @throws jp.co.sra.smalltalk.SmalltalkException DOCUMENT ME!
	 * @category pretty printing
	 */
	public String ppString() {
		try {
			StringWriter aWriter = new StringWriter();
			this.ppOn_(aWriter);
			return aWriter.toString();
		} catch (IOException e) {
			throw new SmalltalkException(e);
		}
	}

	/**
	 * Print my string representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @exception IOException The exception description.
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		this.printOn_level_(aWriter, 0);
	}

	/**
	 * Print my string representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param level int
	 * @exception IOException The exception description.
	 * @category printing
	 */
	public void printOn_level_(Writer aWriter, int level) throws IOException {
		if ((VerticalLevel != 0) && (level >= VerticalLevel)) {
			aWriter.write("( ... )");
			return;
		}

		if (this.nullList()) {
			super.printOn_(aWriter);
			return;
		}

		aWriter.write('(');
		if (head instanceof JunLispCons) {
			((JunLispCons) head).printOn_level_(aWriter, level + 1);
		} else {
			this.printOn_object_(aWriter, head);
		}
		if (tail instanceof JunLispList) {
			this.printOn_tail_level_(aWriter, (JunLispList) tail, level);
		} else {
			aWriter.write(" . ");
			this.printOn_object_(aWriter, tail);
			aWriter.write(')');
		}
	}

	/**
	 * Print my string representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param anObject java.lang.Object
	 * @exception IOException The exception description.
	 * @category printing
	 */
	public void printOn_object_(Writer aWriter, Object anObject) throws IOException {
		if (anObject instanceof Number) {
			aWriter.write(String.valueOf((Number) anObject));
			return;
		} else if (anObject instanceof StSymbol) {
			aWriter.write(anObject.toString());
			return;
		} else if (anObject instanceof String) {
			aWriter.write('"');
			String aString = (String) anObject;
			for (int i = 0; i < aString.length(); i++) {
				char ch = aString.charAt(i);
				if (ch == '"') {
					aWriter.write('\"');
				} else {
					aWriter.write(ch);
				}
			}
			aWriter.write('"');
			return;
		} else if (anObject instanceof JunLispNil) {
			aWriter.write("nil");
			return;
		} else if (anObject instanceof Vector) {
			int size = ((Vector) anObject).size();
			Object[] anArray = new Object[size];
			((Vector) anObject).copyInto(anArray);
			anObject = anArray;
		} else if (anObject instanceof Object[]) {
			Object[] anArray = (Object[]) anObject;
			aWriter.write("(");
			if (anArray.length > 0) {
				this.printOn_object_(aWriter, anArray[0]);
				for (int i = 1; i < anArray.length; i++) {
					aWriter.write(' ');
					this.printOn_object_(aWriter, anArray[i]);
				}
			}
			aWriter.write(")");
			return;
		}

		aWriter.write('{');
		aWriter.write(anObject.toString());
		aWriter.write('}');
	}

	/**
	 * Print my string representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param cdr jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param level int
	 * @exception IOException The exception description.
	 * @category printing
	 */
	public void printOn_tail_level_(Writer aWriter, JunLispList cdr, int level) throws IOException {
		if (cdr.nullList()) {
			aWriter.write(')');
			return;
		}

		Object tailPart = cdr;
		int count = 1;
		while (tailPart instanceof JunLispCons) {
			JunLispCons tailList = (JunLispCons) tailPart;
			if ((HorizontalLevel != 0) && (count >= HorizontalLevel)) {
				aWriter.write(" ... )");
				return;
			}

			aWriter.write(' ');
			if (tailList.head() instanceof JunLispCons) {
				((JunLispCons) tailList.head()).printOn_level_(aWriter, level + 1);
			} else {
				this.printOn_object_(aWriter, tailList.head());
			}
			tailPart = tailList.tail();
			count++;
		}

		if (tailPart instanceof JunLispList) {
			aWriter.write(')');
		} else {
			aWriter.write(" . ");
			this.printOn_object_(aWriter, tailPart);
			aWriter.write(')');
		}
	}

	/**
	 * Reverse the order of the receiver..
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category functions
	 */
	public JunLispList reverse() {
		JunLispList list = JunLispList.NullList();
		Object cdr = this;
		while (cdr instanceof JunLispCons) {
			list = new JunLispCons(((JunLispCons) cdr).head(), list);
			cdr = ((JunLispCons) cdr).tail();
		}
		return list;
	}

	/**
	 * Replace the head object with the specified object.
	 * 
	 * @param anObject java.lang.Object
	 * @category functions
	 */
	public void rplaca_(Object anObject) {
		this.head_(anObject);
	}

	/**
	 * Replace the tail object with the specified object.
	 * 
	 * @param anObject java.lang.Object
	 * @category functions
	 */
	public void rplacd_(Object anObject) {
		this.tail_(anObject);
	}

	/**
	 * Save the receiver on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @exception IOException The exception description.
	 * @category saving
	 */
	public void saveOn_(Writer aWriter) throws IOException {
		this.saveOn_list_position_(aWriter, this, 0);
		BufferedWriter bw = (aWriter instanceof BufferedWriter) ? (BufferedWriter) aWriter : new BufferedWriter(aWriter);
		bw.newLine();
		bw.flush();
	}

	/**
	 * Save the receiver on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param list java.lang.Object
	 * @param position int
	 * @exception IOException The exception description.
	 * @category saving
	 */
	public void saveOn_list_position_(Writer aWriter, Object list, int position) throws IOException {
		if ((list instanceof JunLispCons) == false) {
			this.saveOn_object_(aWriter, list);
			return;
		}

		BufferedWriter bw = (aWriter instanceof BufferedWriter) ? (BufferedWriter) aWriter : new BufferedWriter(aWriter);
		JunLispCons cons = (JunLispCons) list;
		if ((cons.head() instanceof JunLispCons) == false) {
			bw.write('(');
			this.saveOn_object_(bw, cons.head());
			if (cons.tail() instanceof JunLispList) {
				int length = 0;
				this.saveOn_tail_position_(bw, (JunLispList) cons.tail(), position + 1 + length);
			} else {
				bw.write(" . ");
				this.saveOn_object_(bw, cons.tail());
			}
			bw.write(')');
		} else {
			bw.write('(');
			this.saveOn_list_position_(bw, cons.head(), position + 1);
			if (cons.tail() instanceof JunLispCons) {
				if (((JunLispCons) cons.tail()).head() instanceof JunLispCons) {
					bw.newLine();
					this.saveOn_spaceAndTab_(bw, position);
					this.saveOn_tail_position_(bw, (JunLispList) cons.tail(), position);
				} else {
					this.saveOn_space_(bw, 1);
					this.saveOn_tail_position_(bw, (JunLispList) cons.tail(), position + 1);
				}
			} else {
				if ((cons.tail() instanceof JunLispList) == false) {
					bw.write(" . ");
					this.saveOn_object_(bw, cons.tail());
				}
			}
			bw.write(')');
		}
		bw.flush();
	}

	/**
	 * Save the receiver on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param anObject java.lang.Object
	 * @exception IOException The exception description.
	 * @category saving
	 */
	public void saveOn_object_(Writer aWriter, Object anObject) throws IOException {
		if (anObject instanceof Number) {
			aWriter.write((String.valueOf((Number) anObject)).toLowerCase());
			return;
		} else if (anObject instanceof StSymbol) {
			aWriter.write(anObject.toString());
			return;
		} else if (anObject instanceof String) {
			aWriter.write('"');
			String anString = (String) anObject;
			for (int i = 0; i < anString.length(); i++) {
				char ch = anString.charAt(i);
				if (ch == '"') {
					aWriter.write('"');
				}
				aWriter.write(ch);
			}
			aWriter.write('"');
			return;
		} else if (anObject instanceof JunLispNil) {
			aWriter.write("nil");
			return;
		} else if (anObject instanceof Vector) {
			int size = ((Vector) anObject).size();
			Object[] anArray = new Object[size];
			((Vector) anObject).copyInto(anArray);
			anObject = anArray;
		} else if (anObject instanceof Object[]) {
			Object[] anArray = (Object[]) anObject;
			aWriter.write("(");
			if (anArray.length > 0) {
				this.printOn_object_(aWriter, anArray[0]);
				for (int i = 1; i < anArray.length; i++) {
					aWriter.write(' ');
					this.printOn_object_(aWriter, anArray[i]);
				}
			}
			aWriter.write(")");
			return;
		}

		aWriter.write('{');
		if (anObject == null) {
			aWriter.write("nil");
		} else if (anObject instanceof JunPoint) {
			aWriter.write(anObject.toString().toLowerCase());
		} else if (anObject instanceof Color) {
			aWriter.write(StColorValue._PrintStringOf((Color) anObject));
		} else if (anObject instanceof StObject) {
			aWriter.write(((StObject) anObject).storeString());
		} else {
			aWriter.write(anObject.toString());
		}
		aWriter.write('}');
	}

	/**
	 * Save the specified number of spaces.
	 * 
	 * @param aWriter java.io.Writer
	 * @param number int
	 * @exception IOException The exception description.
	 * @category saving
	 */
	public void saveOn_space_(Writer aWriter, int number) throws IOException {
		for (int i = 0; i < number; i++) {
			aWriter.write(' ');
		}
	}

	/**
	 * Save the specified number of spaces.
	 * 
	 * @param aWriter java.io.Writer
	 * @param number int
	 * @exception IOException The exception description.
	 * @category saving
	 */
	public void saveOn_spaceAndTab_(Writer aWriter, int number) throws IOException {
		int tabs = number / this.tabStop();
		int spaces = number - (tabs * this.tabStop());
		for (int i = 0; i < (tabs * (this.tabStop() / 4)); i++) {
			aWriter.write('\t');
		}
		for (int i = 0; i < spaces; i++) {
			aWriter.write(' ');
		}
	}

	/**
	 * Save the receiver on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param list jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param position int
	 * @exception IOException The exception description.
	 * @category saving
	 */
	public void saveOn_tail_position_(Writer aWriter, JunLispList list, int position) throws IOException {
		if (list.nullList()) {
			return;
		}

		BufferedWriter bw = (aWriter instanceof BufferedWriter) ? (BufferedWriter) aWriter : new BufferedWriter(aWriter);
		JunLispCons cons = (JunLispCons) list;
		if (cons.tail() instanceof JunLispList) {
			if (((JunLispList) cons.tail()).nullList()) {
				this.saveOn_space_(bw, 1);
				this.saveOn_list_position_(bw, cons.head(), position + 1);
			} else {
				this.saveOn_space_(bw, 1);
				this.saveOn_list_position_(bw, cons.head(), position + 1);
				bw.newLine();
				this.saveOn_spaceAndTab_(bw, position);
				this.saveOn_tail_position_(bw, (JunLispList) cons.tail(), position);
			}
		} else {
			this.saveOn_space_(bw, 1);
			this.saveOn_list_position_(bw, cons.head(), position + 1);
			bw.write(" . ");
			this.saveOn_object_(bw, cons.tail());
		}
	}

	/**
	 * Generate the string for saving the receiver.
	 * 
	 * @return String
	 * @throws SmalltalkException DOCUMENT ME!
	 * @category saving
	 */
	public String saveString() {
		try {
			StringWriter aWriter = new StringWriter();
			this.saveOn_(aWriter);
			return aWriter.toString();
		} catch (IOException e) {
			throw new SmalltalkException(e);
		}
	}

	/**
	 * Answer the tail object of the receiver.
	 * 
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object tail() {
		return tail;
	}

	/**
	 * Set the tail object of the receiver.
	 * 
	 * @param anObject java.lang.Object
	 * @category accessing
	 */
	public void tail_(Object anObject) {
		tail = anObject;
	}

	/**
	 * Convert the receiver as a Vector.
	 * 
	 * @return java.util.Vector
	 * @category converting
	 */
	public Vector toVector() {
		int size = this.length();
		Vector vector = new Vector(size);
		Object list = this;
		for (int i = 0; list instanceof JunLispCons; i++) {
			vector.addElement(((JunLispCons) list).head());
			list = ((JunLispCons) list).tail();
		}
		return vector;
	}

	/**
	 * Answer the number for a tab stop.
	 * 
	 * @return int
	 * @category private
	 */
	protected int tabStop() {
		return 8;
	}
}