package jp.co.sra.jun.goodies.itemlist;

import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunChoiceListModel class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/15 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChoiceListModel.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunChoiceListModel extends JunItemListModel {
	/**
	 * Create a new instance of JunChoiceListModel.
	 * 
	 * @category Instance creation
	 */
	public JunChoiceListModel() {
		super();
	}

	/**
	 * Create a new instance of JunChoiceListModel.
	 * 
	 * @param stringCollection java.lang.String[]
	 * @category Instance creation
	 */
	public JunChoiceListModel(String[] stringCollection) {
		super(stringCollection);
	}

	/**
	 * Create a new instance of JunChoiceListModel.
	 * 
	 * @param stringCollection java.lang.String[]
	 * @param booleanCollection boolean[]
	 * @category Instance creation
	 */
	public JunChoiceListModel(String[] stringCollection, boolean[] booleanCollection) {
		super(stringCollection, booleanCollection);
	}

	/**
	 * Create a new instance of JunChoiceListModel.
	 * 
	 * @param stringCollection java.lang.String[]
	 * @param checkBooleanCollection boolean[]
	 * @param lockBooleanCollection boolean[]
	 * @category Instance creation
	 */
	public JunChoiceListModel(String[] stringCollection, boolean[] checkBooleanCollection, boolean[] lockBooleanCollection) {
		super(stringCollection, checkBooleanCollection, lockBooleanCollection);
	}

	/**
	 * Answer the default view.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return JunChoiceListViewAwt.OnScrollPaneWithButtons(this);
		} else {
			return JunChoiceListViewSwing.OnScrollPaneWithButtons(this);
		}
	}

	/**
	 * Answer the window title.
	 * 
	 * @return java.lang.String
	 * @category viewing
	 */
	protected String windowTitle() {
		return JunSystem.$String("Choice List");
	}

}
