package jp.co.sra.jun.goodies.image.support;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.util.Map;

import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunImageToAsciiTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2000/12/13 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2006/12/37 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun668 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImageToAsciiTestExamples.java,v 8.12 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunImageToAsciiTestExamples extends JunTestExamples {

	/**
	 * Example: Open the application
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example() {
		JunImageToAscii imageToAscii = new JunImageToAscii();
		imageToAscii.open();

		return true;
	}

	/**
	 * Example0: Show characters' luminances.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example0() {
		JunImageToAscii imageToAscii = new JunImageToAscii();
		StComposedText composedText = new StComposedText("A", JunImageToAscii.Font());
		int imageWidth = composedText.width();
		int imageHeight = composedText.height();
		Map.Entry[] characterTable = (Map.Entry[]) imageToAscii.characterTable();
		int maxElements = 0;
		for (int i = 0; i < characterTable.length; i++) {
			Object[] elements = (Object[]) characterTable[i].getValue();
			maxElements = Math.max(maxElements, elements.length);
		}

		Dimension extent = new Dimension((maxElements * imageWidth * 2) + 100, characterTable.length * imageHeight);
		Image image = new StImage(extent).image();
		Graphics graphics = null;
		try {
			graphics = image.getGraphics();
			if (graphics instanceof Graphics2D) {
				((Graphics2D) graphics).setBackground(Color.white);
			}

			float brightness = 5.0f / 6.0f;
			graphics.setColor(new Color(brightness, brightness, brightness));
			graphics.fillRect(0, 0, extent.width, extent.height);

			int y = imageHeight - 2;
			for (int i = 0; i < characterTable.length; i++) {
				float luminance = ((Number) characterTable[i].getKey()).floatValue();
				luminance = Math.round(luminance * 1000) / 1000.0f;
				graphics.setColor(Color.black);
				graphics.drawString(String.valueOf(luminance), 4, y);

				Object[] collection = (Object[]) characterTable[i].getValue();
				int x = 100;
				for (int j = 0; j < collection.length; j++) {
					Object[] association = (Object[]) collection[j];
					Character aCharacter = (Character) association[0];
					graphics.drawString(aCharacter.toString(), x, y);
					x += imageWidth;

					float[] feature = (float[]) association[1];
					int divisionWidth = imageToAscii.divisionPoint().width;
					int divisionHeight = imageToAscii.divisionPoint().height;
					StImage featureImage = new StImage(divisionWidth, divisionHeight);
					for (int yy = 0; yy < divisionHeight; yy++) {
						for (int xx = 0; xx < divisionWidth; xx++) {
							int index = (divisionWidth * yy) + xx;
							brightness = feature[index];
							Color color = new Color(brightness, brightness, brightness);
							featureImage.valueAtPoint_put_(new Point(xx, yy), color);
						}
					}

					int ix = x + ((imageWidth - divisionWidth) / 2);
					int iy = y - divisionHeight;
					featureImage.displayOn_at_(graphics, new Point(ix, iy));
					x += imageWidth;
				}

				y += imageHeight;
			}

			image.flush();
		} finally {
			if (graphics != null) {
				graphics.dispose();
			}
		}

		JunImageAdjuster.Show_(new StImage(image));

		return true;
	}

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		String aString = JunImageToAscii.Convert_length_(StImage._FromUser(), 78);
		System.out.println(aString);

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunImageToAsciiTestExamples();
	}

}
