package jp.co.sra.jun.goodies.image.support;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunImageBorderDecoratorTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/07/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun576 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImageBorderDecoratorTestExamples.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunImageBorderDecoratorTestExamples extends JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @throws InvocationTargetException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchMethodException 
	 * @throws IllegalArgumentException 
	 * @category Examples
	 */
	public static boolean Example1() throws IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
		BufferedImage aBufferedImage = JunImageUtility.FromDisplay_(new Rectangle(0, 0, 200, 100));
		JunImageBorderDecorator imageDecorator = new JunImageBorderDecorator(aBufferedImage);
		imageDecorator.boxColor_(Color.yellow);
		imageDecorator.borderColor_(Color.magenta);

		ArrayList aCollection = new ArrayList();
		Point aPoint = new Point(200, 200);

		String[] selectors = new String[] { "originalImage", "simpleImage", "firstImage", "currentImage", "lastImage", "decoratedImage" };
		for (int i = 0; i < selectors.length; i++) {
			StImage anImage = (StImage) imageDecorator.perform_(selectors[i]);
			JunImageDisplayModel aModel = JunImageDisplayModel.Show_at_(anImage, aPoint);
			Frame aFrame = (Frame) aModel.getWindow();
			aFrame.setTitle(selectors[i] + " " + aFrame.getTitle());

			aCollection.add(aModel);
			aPoint.translate(25, 25);
		}

		JunImageDisplayModel[] models = (JunImageDisplayModel[]) aCollection.toArray(new JunImageDisplayModel[aCollection.size()]);
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(models);
		}

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @throws InvocationTargetException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchMethodException 
	 * @throws IllegalArgumentException 
	 * @category Examples
	 */
	public static boolean Example2() throws IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
		BufferedImage aBufferedImage = JunImageUtility.FromDisplay_(new Rectangle(0, 0, 200, 100));
		JunImageBorderDecorator imageDecorator = new JunImageBorderDecorator(aBufferedImage);
		imageDecorator.imageExtent_(new Dimension(300, 300));
		imageDecorator.borderWidth_(5);
		imageDecorator.keepAspect_(false);
		imageDecorator.borderColor_(Color.magenta);

		ArrayList aCollection = new ArrayList();
		Point aPoint = new Point(200, 200);

		String[] selectors = new String[] { "originalImage", "simpleImage", "firstImage", "currentImage", "lastImage", "decoratedImage" };
		for (int i = 0; i < selectors.length; i++) {
			StImage anImage = (StImage) imageDecorator.perform_(selectors[i]);
			JunImageDisplayModel aModel = JunImageDisplayModel.Show_at_(anImage, aPoint);
			Frame aFrame = (Frame) aModel.getWindow();
			aFrame.setTitle(selectors[i] + " " + aFrame.getTitle());

			aCollection.add(aModel);
			aPoint.translate(25, 25);
		}

		JunImageDisplayModel[] models = (JunImageDisplayModel[]) aCollection.toArray(new JunImageDisplayModel[aCollection.size()]);
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(models);
		}

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 * @throws InvocationTargetException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchMethodException 
	 * @throws IllegalArgumentException 
	 * @category Examples
	 */
	public static boolean Example3() throws IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
		BufferedImage aBufferedImage = JunImageUtility.FromDisplay_(new Rectangle(0, 0, 200, 100));
		JunImageBorderDecorator imageDecorator = new JunImageBorderDecorator(aBufferedImage);
		imageDecorator.imageExtent_(new Dimension(300, 300));
		imageDecorator.keepAspect_(true);
		imageDecorator.borderWidth_(2);
		imageDecorator.boxColor_(Color.yellow);
		imageDecorator.borderColor_(Color.magenta);

		ArrayList aCollection = new ArrayList();
		Point aPoint = new Point(200, 200);

		String[] selectors = new String[] { "decoratedImage", "simpleImage" };
		for (int i = 0; i < selectors.length; i++) {
			StImage anImage = (StImage) imageDecorator.perform_(selectors[i]);
			JunImageDisplayModel aModel = JunImageDisplayModel.Show_at_(anImage, aPoint);
			Frame aFrame = (Frame) aModel.getWindow();
			aFrame.setTitle(selectors[i] + " " + aFrame.getTitle());

			aCollection.add(aModel);
			aPoint.translate(25, 25);
		}

		JunImageDisplayModel[] models = (JunImageDisplayModel[]) aCollection.toArray(new JunImageDisplayModel[aCollection.size()]);
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(models);
		}

		return true;
	}

	/**
	 * Example4:
	 * 
	 * @return boolean
	 * @throws InvocationTargetException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchMethodException 
	 * @throws IllegalArgumentException 
	 * @category Examples
	 */
	public static boolean Example4() throws IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
		JunImageBorderDecorator imageDecorator = new JunImageBorderDecorator();
		imageDecorator.imageExtent_(new Dimension(100, 100));
		imageDecorator.boxColor_(Color.yellow);

		ArrayList aCollection = new ArrayList();
		Point aPoint = new Point(200, 200);

		String[] selectors = new String[] { "simpleImage", "firstImage", "currentImage", "lastImage", "decoratedImage" };
		for (int i = 0; i < selectors.length; i++) {
			StImage anImage = (StImage) imageDecorator.perform_(selectors[i]);
			JunImageDisplayModel aModel = JunImageDisplayModel.Show_at_(anImage, aPoint);
			Frame aFrame = (Frame) aModel.getWindow();
			aFrame.setTitle(selectors[i] + " " + aFrame.getTitle());

			aCollection.add(aModel);
			aPoint.translate(25, 25);
		}

		JunImageDisplayModel[] models = (JunImageDisplayModel[]) aCollection.toArray(new JunImageDisplayModel[aCollection.size()]);
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(models);
		}

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunImageBorderDecoratorTestExamples();
	}

}
