package jp.co.sra.jun.goodies.freehand;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.system.framework.JunAbstractController;

/**
 * JunFreehandController class
 * 
 *  @author    nisinaka
 *  @created   2002/07/08 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFreehandController.java,v 8.10 2008/02/20 06:31:34 nisinaka Exp $
 */
public class JunFreehandController extends JunAbstractController implements MouseListener, MouseMotionListener {

	private static final int _DeltaTime = 20;

	protected Point _currentPoint;
	protected Point _previousPoint;
	protected Vector _pointCollection;
	protected long _previousTime;
	protected Vector _timeCollection;

	/**
	 * Answer the model as a JunFreehandPage.
	 * 
	 * @return jp.co.sra.jun.goodies.freehand.JunFreehandPage
	 */
	public JunFreehandPage getModel() {
		return (JunFreehandPage) this.model();
	}

	/**
	 * Invoked when a mouse button is dragged on a component.
	 * 
	 * @param e java.awt.event.MouseEvent
	 */
	public void mouseDragged(MouseEvent e) {
		_currentPoint = e.getPoint();

		if ((_previousPoint == null) || _currentPoint.equals(_previousPoint)) {
			return;
		}

		long currentTime = System.currentTimeMillis();

		if ((currentTime - _previousTime) <= _DeltaTime) {
			return;
		}

		_pointCollection.add(_currentPoint);
		_previousPoint = _currentPoint;

		_timeCollection.add(new Long(currentTime));
		_previousTime = currentTime;

		Point[] points = null;
		int size = _pointCollection.size();

		if (size >= 4) {
			points = new Point[] {(Point) _pointCollection.get(size - 4), (Point) _pointCollection.get(size - 3), (Point) _pointCollection.get(size - 2), (Point) _pointCollection.get(size - 1)};
		} else if (size >= 3) {
			points = new Point[] {(Point) _pointCollection.get(size - 3), (Point) _pointCollection.get(size - 2), (Point) _pointCollection.get(size - 1)};
		} else {
			points = new Point[] {(Point) _pointCollection.get(size - 2), (Point) _pointCollection.get(size - 1)};
		}

		Graphics aGraphics = null;
		try {
			aGraphics = this._graphics();
			this.getModel()._drawPolyline(aGraphics, points);
		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
				aGraphics = null;
			}
		}

	}

	/**
	 * Invoked when a mouse button is pressed on a component.
	 * 
	 * @param e java.awt.event.MouseEvent
	 */
	public void mousePressed(MouseEvent e) {
		this._flush();

		_currentPoint = _previousPoint = e.getPoint();
		_pointCollection = new Vector(1024);
		_pointCollection.add(_currentPoint);
		_timeCollection = new Vector(1024);
		_previousTime = System.currentTimeMillis();
		_timeCollection.add(new Long(_previousTime));

		Graphics aGraphics = null;
		try {
			aGraphics = this._graphics();
			this.getModel()._drawDotbox(aGraphics, (new StRectangle(_currentPoint.x, _currentPoint.y, _currentPoint.x + 1, _currentPoint.y + 1)).expandedBy_((int) Math.max(this.getModel().nibWidth() / 2, 0)));

		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
				aGraphics = null;
			}
		}
	}

	/**
	 * Invoked when a mouse button is released on a component.
	 * 
	 * @param e java.awt.event.MouseEvent
	 */
	public void mouseReleased(MouseEvent e) {
		Graphics aGraphics = null;
		try {
			aGraphics = this._graphics();
			this.getModel()._drawPolyline(aGraphics, _pointCollection);
			this.getModel()._drawDotbox(aGraphics, (new StRectangle(_currentPoint.x, _currentPoint.y, _currentPoint.x + 1, _currentPoint.y + 1)).expandedBy_((int) Math.max(this.getModel().nibWidth() / 2, 0)));
		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
				aGraphics = null;
			}
		}
		this.getModel().pointCollection_boundingBox_timeCollection_(_pointCollection, this._component().getBounds(), _timeCollection);

		this._flush();
	}

	/**
	 * Answer the view as a component.
	 * 
	 * @return java.awt.Component
	 */
	protected Component _component() {
		return (Component) this.view();
	}

	/**
	 * Flush the instance variables.
	 */
	protected void _flush() {
		_currentPoint = null;
		_previousPoint = null;
		_pointCollection = null;
		_previousTime = 0;
		_timeCollection = null;
	}

	/**
	 * Answer the graphics of the component. The sender is responsible to
	 * dispose.
	 * 
	 * @return java.awt.Graphics2D
	 */
	protected Graphics2D _graphics() {
		Graphics2D _graphics = (Graphics2D) this._component().getGraphics();
		_graphics.setPaint(this.getModel().nibColor());
		_graphics.setStroke(this.getModel()._stroke(this.getModel().nibWidth()));

		return _graphics;
	}

	/**
	 * Add listeners.
	 * 
	 * @param aView jp.co.sra.smalltalk.StView
	 */
	protected void buildListener(StView aView) {
		Component aComponent = (Component) aView;
		aComponent.addMouseListener(this);
		aComponent.addMouseMotionListener(this);
	}
}
