package jp.co.sra.jun.goodies.font;

import java.awt.List;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.display.JunDisplayViewAwt;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunFontViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2003/02/28 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun642 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFontViewAwt.java,v 8.12 2008/02/20 06:31:33 nisinaka Exp $
 */
public class JunFontViewAwt extends JunAbstractViewPanel implements JunFontView {

	protected JunDisplayViewAwt displayView;
	protected List fontNameList;
	protected List fontSizeList;

	/**
	 * Create a new instance of JunFontViewAwt and initialize it with the JunFontModel.
	 *
	 * @param newFontModel jp.co.sra.jun.goodies.font.JunFontModel
	 * @category Instance creation
	 */
	public JunFontViewAwt(JunFontModel newFontModel) {
		super(newFontModel);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.displayView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0f, 79));
		this.add(this.fontNameList(), WindowSpecLayout.Position(0f, 1, 0f, 80, 0.7f, -1, 1f, -1));
		this.add(this.fontSizeList(), WindowSpecLayout.Position(0.7f, 0, 0f, 80, 1f, -1, 1f, -1));
		this.setSize(350, 250);
	}

	/**
	 * Add WindowListener to make a selection visible.
	 * JList#ensureIndexIsVisible does not work before a window is opened.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#addNotify()
	 * @category initialize-release
	 */
	public void addNotify() {
		super.addNotify();

		this.topComponent().addWindowListener(new WindowAdapter() {
			public void windowOpened(WindowEvent e) {
				super.windowOpened(e);
				updateFontNameList();
				updateFontSizeList();
			}
		});
	}

	/**
	 * Answer my model as a JunFontModel.
	 *
	 * @return jp.co.sra.jun.goodies.font.JunFontModel
	 * @see jp.co.sra.jun.goodies.font.JunFontView#getFontModel()
	 * @category model accessing
	 */
	public JunFontModel getFontModel() {
		return (JunFontModel) this.model();
	}

	/**
	 * Answer my display view.
	 *
	 * @return jp.co.sra.jun.goodies.display.JunDisplayViewAwt
	 * @category user interface
	 */
	protected JunDisplayViewAwt displayView() {
		if (displayView == null) {
			displayView = new JunDisplayViewAwt(this.getFontModel().displayModel());
		}
		return displayView;
	}

	/**
	 * Answer my font name list.
	 *
	 * @return java.awt.List
	 * @category user interface
	 */
	protected List fontNameList() {
		if (fontNameList == null) {
			fontNameList = new List();
			fontNameList.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					if (e.getStateChange() == ItemEvent.SELECTED) {
						getFontModel().setFontNameIndex(((Number) e.getItem()).intValue());
					}
				}
			});
		}
		return fontNameList;
	}

	/**
	 * Answer my font name list.
	 *
	 * @return java.awt.List
	 * @category user interface
	 */
	protected List fontSizeList() {
		if (fontSizeList == null) {
			fontSizeList = new List();
			fontSizeList.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					if (e.getStateChange() == ItemEvent.SELECTED) {
						getFontModel().setFontSizeIndex(((Number) e.getItem()).intValue());
					}
				}
			});
		}
		return fontSizeList;
	}

	/**
	 * Update the font name list.
	 * 
	 * @category updating
	 */
	protected void updateFontNameList() {
		fontNameList.removeAll();

		String[] fontNames = this.getFontModel().fontNames();
		for (int i = 0; i < fontNames.length; i++) {
			fontNameList.add(fontNames[i]);
		}

		int fontNameIndex = this.getFontModel().getFontNameIndex();
		if (fontNameIndex >= 0) {
			fontNameList.select(fontNameIndex);
			fontNameList.makeVisible(fontNameIndex);
		}
	}

	/**
	 * Update the font size list.
	 * 
	 * @category updating
	 */
	protected void updateFontSizeList() {
		fontSizeList.removeAll();

		int[] fontSizes = this.getFontModel().fontSizes();
		for (int i = 0; i < fontSizes.length; i++) {
			fontSizeList.add(String.valueOf(fontSizes[i]));
		}

		int fontSizeIndex = this.getFontModel().getFontSizeIndex();
		if (fontSizeIndex >= 0) {
			fontSizeList.select(fontSizeIndex);
			fontSizeList.makeVisible(fontSizeIndex);
		}
	}

}
