package jp.co.sra.jun.goodies.drawing.properties;

import java.awt.Dimension;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunTextboxPropertiesViewAwt class
 * 
 *  @author    m-asada
 *  @created   2005/05/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextboxPropertiesViewAwt.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public class JunTextboxPropertiesViewAwt extends JunAbstractViewPanel implements JunTextboxPropertiesView {
	protected JunTextPropertiesViewAwt textPropertiesView;
	protected JunRectangularShapePropertiesViewAwt borderPropertiesView;

	/**
	 * Create a new instance of <code>JunTextboxPropertiesViewAwt</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunTextboxPropertiesViewAwt() {
		super();
	}

	/**
	 * Create a new instance of <code>JunTextboxPropertiesViewAwt</code> and initialize it.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.drawing.properties.JunTextboxPropertiesModel
	 * @category Instance creation
	 */
	public JunTextboxPropertiesViewAwt(JunTextboxPropertiesModel newModel) {
		super(newModel);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		textPropertiesView = null;
		borderPropertiesView = null;
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());

		this.add(this.textPropertiesView(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, -345, 1f, 0));
		this.add(this.borderPropertiesView(), WindowSpecLayout.Position(1f, -343, 0f, 0, 1f, 0, 1f, 0));

		this.setSize(new Dimension(655, 330));
	}

	/**
	 * Release the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StView#release()
	 * @category initialize-release
	 */
	public void release() {
		this.textPropertiesView().release();
		this.borderPropertiesView().release();
		super.release();
	}

	/**
	 * Answer the model as JunTextboxPropertiesModel.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.properties.JunTextboxPropertiesModel
	 * @see jp.co.sra.jun.goodies.drawing.properties.JunTextboxPropertiesView#getModel()
	 * @category model accessing
	 */
	public JunTextboxPropertiesModel getModel() {
		return (JunTextboxPropertiesModel) this.model();
	}

	/**
	 * Answer the receiver's text properties view.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.properties.JunTextPropertiesViewAwt
	 * @category interface opening
	 */
	public JunTextPropertiesViewAwt textPropertiesView() {
		if (textPropertiesView == null) {
			textPropertiesView = new JunTextPropertiesViewAwt(this.getModel().textPropertiesModel());
		}
		return textPropertiesView;
	}

	/**
	 * Answer the receiver's border properties view.
	 *
	 * @return jp.co.sra.jun.goodies.drawing.properties.JunRectangularShapePropertiesViewAwt
	 * @category interface opening
	 */
	public JunRectangularShapePropertiesViewAwt borderPropertiesView() {
		if (borderPropertiesView == null) {
			borderPropertiesView = new JunRectangularShapePropertiesViewAwt(this.getModel().borderPropertiesModel());
		}
		return borderPropertiesView;
	}

	/**
	 * Update the receiver according to the change notification from the model.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (this.isShowing() == false) {
			return;
		}

		StSymbol aSymbol = evt.getAspect();
		if (aSymbol == $("foregroundColor") || aSymbol == $("backgroundColor") || aSymbol == $("borderColor") || aSymbol == $("lineWidth")) {
			return;
		}
		if (aSymbol == $("fill")) {
			if (this.borderPropertiesView().fillView().getState() && this.getModel().textboxElement().backgroundColor() != null) {
				return;
			}
			if (this.getModel().textboxElement().backgroundColor() != null) {
				this.borderPropertiesView().fillView().setState(true);
			} else {
				this.borderPropertiesView().fillView().setState(false);
			}
			return;
		}

		super.update_(evt);
	}
}
