package jp.co.sra.jun.goodies.drawing.properties;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.goodies.colors.JunColorChoiceHSB;
import jp.co.sra.jun.goodies.colors.JunColorChoiceModel;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunTextElement;
import jp.co.sra.jun.goodies.texteditor.JunTextEditor;

/**
 * JunTextPropertiesModel class
 * 
 *  @author    m-asada
 *  @created   2005/05/11 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextPropertiesModel.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public class JunTextPropertiesModel extends JunDrawingElementPropertiesModel {
	protected JunTextEditor textEditor;
	protected JunColorChoiceModel foregroundColorChoiceModel;

	/**
	 * Create a new instance of JunTextPropertiesModel and initialize it.
	 * 
	 * @param textElement jp.co.sra.jun.goodies.drawing.element.JunTextElement
	 * @category Instance creation
	 */
	public JunTextPropertiesModel(JunTextElement textElement) {
		super(textElement);
	}

	/**
	 * Initialize the ApplicationModel when created.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		textEditor = null;
		foregroundColorChoiceModel = null;
	}

	/**
	 * Set the receiver's rectangular shape element.
	 * 
	 * @param newDrawingElement jp.co.sra.jun.goodies.drawing.element.JunDrawingElement
	 * @category accessing
	 */
	protected void drawingElement_(JunDrawingElement newDrawingElement) {
		if (newDrawingElement == null) {
			return;
		}
		super.drawingElement_(newDrawingElement);

		JunTextElement newTextElement = (JunTextElement) newDrawingElement;
		this.foregroundColorChoiceModel().color_(newTextElement.foregroundColor());
	}

	/**
	 * Answer the receiver's text element.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.element.JunTextElement
	 * @category accessing
	 */
	public JunTextElement textElement() {
		return (JunTextElement) this.drawingElement();
	}

	/**
	 * Get the text.
	 * 
	 * @return java.lang.String
	 * @category accessing
	 */
	public String text() {
		return this.textElement().text();
	}

	/**
	 * Set the text.
	 * 
	 * @param aText java.lang.String
	 * @category accessing
	 */
	public void text_(String aText) {
		this.textElement().text_(aText);
		this.textElement().map().changed_with_($("redisplay"), this.textElement().bounds());
		this.changed_($("text"));
	}

	/**
	 * Answer the receiver's text editor model.
	 * 
	 * @return jp.co.sra.jun.goodies.texteditor.JunTextEditor
	 * @category aspects
	 */
	public JunTextEditor textEditor() {
		if (textEditor == null) {
			textEditor = new JunTextEditor(this.text());
			textEditor.compute_(new StBlockClosure() {
				public Object value_(Object value) {
					JunTextPropertiesModel.this.text_((String) value);
					return null;
				}

			});
		}
		return textEditor;
	}

	/**
	 * Answer the receiver's choice model of foreground color.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceModel
	 * @category aspects
	 */
	public JunColorChoiceModel foregroundColorChoiceModel() {
		if (foregroundColorChoiceModel == null) {
			foregroundColorChoiceModel = new JunColorChoiceHSB();
			foregroundColorChoiceModel.compute_(new StBlockClosure() {
				public Object value() {
					JunTextPropertiesModel.this.updateForegroundColor();
					return null;
				}
			});
		}
		return foregroundColorChoiceModel;
	}

	/**
	 * Answer the default view of the model.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunTextPropertiesViewAwt(this);
		} else {
			return new JunTextPropertiesViewSwing(this);
		}
	}

	/**
	 * Called when the foreground color is changed.
	 * 
	 * @category updating
	 */
	protected void updateForegroundColor() {
		if (this.foregroundColorChoiceModel().color().equals(this.textElement().foregroundColor()) == false) {
			this.textElement().foregroundColor_(this.foregroundColorChoiceModel().color());
			this.textElement().map().changed_with_($("redisplay"), this.textElement().bounds());
			this.changed_($("foregroundColor"));
		}
	}
}
