package jp.co.sra.jun.goodies.drawing.properties;

import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunDrawingElementPropertiesModel class
 * 
 *  @author    m-asada
 *  @created   2005/05/19 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDrawingElementPropertiesModel.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public abstract class JunDrawingElementPropertiesModel extends JunApplicationModel {
	protected JunDrawingElement drawingElement;

	/**
	 * Create a new instance of JunAbstractElementPropertiesModel and initialize it.
	 * 
	 * @param drawingElement jp.co.sra.jun.goodies.drawing.element.JunDrawingElement
	 * @category Instance creation
	 */
	public JunDrawingElementPropertiesModel(JunDrawingElement drawingElement) {
		super();
		this.drawingElement_(drawingElement);
	}

	/**
	 * Answer the receiver's rectangular shape element.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.element.JunDrawingElement
	 * @category accessing
	 */
	public JunDrawingElement drawingElement() {
		return drawingElement;
	}

	/**
	 * Set the receiver's rectangular shape element.
	 * 
	 * @param newDrawingElement jp.co.sra.jun.goodies.drawing.element.JunDrawingElement
	 * @category accessing
	 */
	protected void drawingElement_(JunDrawingElement newDrawingElement) {
		if (newDrawingElement == null) {
			return;
		}
		drawingElement = newDrawingElement;
	}

	/**
	 * Initialize the ApplicationModel when created.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		drawingElement = null;
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Properties");
	}
}
