package jp.co.sra.jun.goodies.colors;

import jp.co.sra.jun.system.support.*;

/**
 * JunColorChoiceTestExamples class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/11/05 (by Hirotsugu Kondo)
 *  @updated   1999/08/31 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorChoiceTestExamples.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorChoiceTestExamples extends JunTestExamples {

	/**
	 * Example: open HBS color model window
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunColorChoiceHBS colorChoice;
		colorChoice = new JunColorChoiceHBS();
		colorChoice.open();

		return true;
	}

	/**
	 * Example: open HSB color model window
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunColorChoiceHSB colorChoice;
		colorChoice = new JunColorChoiceHSB();
		colorChoice.open();

		return true;
	}

	/**
	 * Example: open SBH color model window
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunColorChoiceSBH colorChoice;
		colorChoice = new JunColorChoiceSBH();
		colorChoice.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunColorChoiceTestExamples();
	}
}