package jp.co.sra.jun.goodies.colors;

import java.awt.Color;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunColorBarDialogTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/06/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun492 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorBarDialogTestExamples.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorBarDialogTestExamples extends JunTestExamples {

	/**
	 * Example1: Request with a default JunColorBarDialog.
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		Object[] answer = JunColorBarDialog.Request();
		if (answer == null) {
			return false;
		}

		Color aColor = (Color) answer[0];
		double value = ((Number) answer[1]).doubleValue();
		double[] interval = (double[]) answer[2];
		System.out.println(StColorValue._PrintStringOf(aColor) + " is " + (float) value + " in [" + (float) interval[0] + ", " + (float) interval[1] + "]");
		return true;
	}

	/**
	 * Example2: Request with a specified JunColorBarDialog.
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunColorBarHSB colorBar = new JunColorBarHSB();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.hueBounds_(new double[] { 0, (double) 4 / 6 });
		colorBar.saturationBounds_(new double[] { 1, 1 });
		colorBar.brightnessBounds_(new double[] { 1, 1 });

		Object[] answer = JunColorBarDialog.Request(JunSystem.$String("Set a color bar"), colorBar);
		if (answer == null) {
			return false;
		}

		Color aColor = (Color) answer[0];
		double value = ((Number) answer[1]).doubleValue();
		double[] interval = (double[]) answer[2];
		System.out.println(StColorValue._PrintStringOf(aColor) + " is " + (float) value + " in [" + (float) interval[0] + ", " + (float) interval[1] + "]");
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunColorBarDialogTestExamples();
	}

}
