package jp.co.sra.jun.goodies.colors;

import java.awt.Color;
import jp.co.sra.smalltalk.StColorValue;

/**
 * JunColorBarCMY class
 * 
 *  @author    nisinaka
 *  @created   2004/06/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun452 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorBarCMY.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorBarCMY extends JunColorBarModel {

	protected double[] cyanBounds;
	protected double[] magentaBounds;
	protected double[] yellowBounds;

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		cyanBounds = null;
		magentaBounds = null;
		yellowBounds = null;
	}

	/**
	 * Answer my current cyan bounds.
	 * 
	 * @return double[]
	 * @category color accessing
	 */
	public double[] cyanBounds() {
		if (cyanBounds == null) {
			cyanBounds = new double[] { 0, 1 };
		}
		return cyanBounds;
	}

	/**
	 * Set my new cyan bounds.
	 * 
	 * @param newBounds double[]
	 * @category color accessing
	 */
	public void cyanBounds_(double[] newBounds) {
		cyanBounds = this.adjustInterval_(newBounds);
		this.changed_($("color"));
	}

	/**
	 * Answer my current magenta bounds.
	 * 
	 * @return double[]
	 * @category color accessing
	 */
	public double[] magentaBounds() {
		if (magentaBounds == null) {
			magentaBounds = new double[] { 0, 1 };
		}
		return magentaBounds;
	}

	/**
	 * Set my new magenta bounds.
	 * 
	 * @param newBounds double[]
	 * @category color accessing
	 */
	public void magentaBounds_(double[] newBounds) {
		magentaBounds = this.adjustInterval_(newBounds);
		this.changed_($("color"));
	}

	/**
	 * Answer my current yellow bounds.
	 * 
	 * @return double[]
	 * @category color accessing
	 */
	public double[] yellowBounds() {
		if (yellowBounds == null) {
			yellowBounds = new double[] { 0, 1 };
		}
		return yellowBounds;
	}

	/**
	 * Set my new yellow bounds.
	 * 
	 * @param newBounds double[]
	 * @category color accessing
	 */
	public void yellowBounds_(double[] newBounds) {
		yellowBounds = this.adjustInterval_(newBounds);
		this.changed_($("color"));
	}

	/**
	 * Answer the color which correspond to the normalized value.
	 * 
	 * @param normalizedValue double
	 * @return java.awt.Color
	 * @see jp.co.sra.jun.goodies.colors.JunColorBarModel#getColor_(double)
	 * @category private
	 */
	protected Color getColor_(double normalizedValue) {
		double cyan = (this.cyanBounds()[1] - this.cyanBounds()[0]) * normalizedValue + this.cyanBounds[0];
		double magenta = (this.magentaBounds()[1] - this.magentaBounds()[0]) * normalizedValue + this.magentaBounds[0];
		double yellow = (this.yellowBounds()[1] - this.yellowBounds()[0]) * normalizedValue + this.yellowBounds[0];
		return StColorValue.Cyan_Magenta_Yellow_(cyan, magenta, yellow);
	}

}
