package jp.co.sra.jun.goodies.catalog;

import java.io.File;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.goodies.progress.JunProgress;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunMovieCatalogTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/05/21 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMovieCatalogTestExamples.java,v 8.11 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunMovieCatalogTestExamples extends JunTestExamples {
	/**
	 * Example 1.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunMovieCatalog movieCatalog = new JunMovieCatalog();
		movieCatalog.make();
		movieCatalog.show();

		return true;
	}

	/**
	 * Example 2.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		JunMovieCatalog movieCatalog = new JunMovieCatalog(aDirectory);
		movieCatalog.visualClip_(new double[] { 0.249d, 0.253d });
		movieCatalog.keyFramePosition_(0.25d);
		movieCatalog.computeWhenProgressMessageChanged_(new StBlockClosure() {
			public Object value_(Object m) {
				System.out.println((String) m);
				return null;
			}
		});
		movieCatalog.make();
		movieCatalog.show();

		return true;
	}

	/**
	 * Example 3.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		final JunMovieCatalog movieCatalog = new JunMovieCatalog(aDirectory);
		movieCatalog.visualClip_(new double[] { 0.24d, 0.28d });
		movieCatalog.keyFramePosition_(0.25d);
		final JunProgress aProgress = new JunProgress();
		movieCatalog.computeWhenProgressMessageChanged_(new StBlockClosure() {
			public Object value_(Object m) {
				aProgress.message_((String) m);
				return null;
			}
		});
		movieCatalog.computeWhenProgressValueChanged_(new StBlockClosure() {
			public Object value_(Object v) {
				aProgress.value_(((Number) v).floatValue());
				return null;
			}
		});
		aProgress.do_(new StBlockClosure() {
			public Object value() {
				movieCatalog.make();
				return null;
			}
		});
		movieCatalog.show();

		return true;
	}

	/**
	 * Example 4.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		final JunMovieCatalog movieCatalog = new JunMovieCatalog(aDirectory);
		movieCatalog.visualClip_(new double[] { 0.24d, 0.28d });
		movieCatalog.keyFramePosition_(0.25d);
		movieCatalog.thumbnailImageSize_(32);
		movieCatalog.numberOfColumns_(3);
		movieCatalog.withFileName_(true);
		final JunProgress aProgress = new JunProgress();
		movieCatalog.computeWhenProgressMessageChanged_(new StBlockClosure() {
			public Object value_(Object m) {
				aProgress.message_((String) m);
				return null;
			}
		});
		movieCatalog.computeWhenProgressValueChanged_(new StBlockClosure() {
			public Object value_(Object v) {
				aProgress.value_(((Number) v).floatValue());
				return null;
			}
		});
		aProgress.do_(new StBlockClosure() {
			public Object value() {
				movieCatalog.make();
				return null;
			}
		});
		movieCatalog.show();

		return true;
	}

	/**
	 * Example 5.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		JunVisualCatalog aMovieCatalog = JunMovieCatalog.Dive_(aDirectory);
		aMovieCatalog.show();

		return true;
	}

	/**
	 * Example 6.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory("");
		if (aDirectory == null) {
			return true;
		}

		JunVisualCatalog anmovieCatalog = JunMovieCatalog.Dive_block_(aDirectory, new StBlockClosure() {
			public Object value_(Object anObject) {
				final JunMovieCatalog movieCatalog = (JunMovieCatalog) anObject;
				movieCatalog.visualClip_(new double[] { 0.24d, 0.28d });
				movieCatalog.keyFramePosition_(0.25d);
				movieCatalog.thumbnailImageSize_(32);
				movieCatalog.numberOfColumns_(3);
				movieCatalog.withFileName_(true);
				final JunProgress aProgress = new JunProgress();
				movieCatalog.computeWhenProgressMessageChanged_(new StBlockClosure() {
					public Object value_(Object m) {
						aProgress.message_((String) m);
						return null;
					}
				});
				movieCatalog.computeWhenProgressValueChanged_(new StBlockClosure() {
					public Object value_(Object v) {
						aProgress.value_(((Number) v).floatValue());
						return null;
					}
				});
				aProgress.do_(new StBlockClosure() {
					public Object value() {
						movieCatalog.make();
						return null;
					}
				});
				return null;
			}
		});
		anmovieCatalog.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunMovieCatalogTestExamples();
	}
}
