package jp.co.sra.jun.goodies.calendar;

import java.awt.Toolkit;
import java.awt.datatransfer.*;
import java.io.IOException;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCalendarTimeModelTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarTimeModelTestExamples.java,v 8.11 2008/02/20 06:31:13 nisinaka Exp $
 */
public class JunCalendarTimeModelTestExamples extends JunTestExamples {
	/**
	 * JunCalendarTimeModel example1.
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		JunCalendarTimeModel calendorTimeModel = new JunCalendarTimeModel();
		calendorTimeModel.open();
		return true;
	}

	/**
	 * JunCalendarTimeModel example2.
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		JunCalendarTimeModel calendarTimeModel = new JunCalendarTimeModel();
		System.out.println(calendarTimeModel);
		calendarTimeModel.copyTime();
		Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
		try {
			System.out.println((String) (clip.getContents(null).getTransferData(DataFlavor.stringFlavor)));
		} catch (IOException e) {
			throw new SmalltalkException(e);
		} catch (UnsupportedFlavorException e) {
		}
		return true;
	}

	/**
	 * JunCalendarTimeModel example3.
	 *
	 * @return boolean
	 */
	public static boolean Example3() {
		JunCalendarTimeModel calendarTimeModel = JunCalendarTimeModel.Hours_minutes_seconds_(22, 33, 44);
		calendarTimeModel.open();
		return true;
	}

	/**
	 * JunCalendarTimeModel example4.
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		JunCalendarTimeModel calendarTimeModel = JunCalendarTimeModel.Hours_minutes_seconds_(10, 33, 44);
		calendarTimeModel.open();
		return true;
	}

	public static void main(String argv[]) {
		new JunCalendarTimeModelTestExamples();
	}
}
