package jp.co.sra.jun.goodies.calendar;

import java.util.Calendar;

import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StView;

/**
 * JunCalendarTimeIntervalModel class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarTimeIntervalModel.java,v 8.11 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarTimeIntervalModel extends JunCalendarModel {
	protected JunCalendarTimeModel fromCalendarTimeModel;
	protected JunCalendarTimeModel toCalendarTimeModel;

	/**
	 * Create instance and set time from fromTime to toTime.
	 *
	 * @param fromTime java.util.Calendar
	 * @param toTime java.util.Calendar
	 * @category Utilities
	 */
	public static JunCalendarTimeIntervalModel From_to_(Calendar fromTime, Calendar toTime) {
		JunCalendarTimeIntervalModel calendarTimeIntervalModel = new JunCalendarTimeIntervalModel();
		calendarTimeIntervalModel.fromCalendarTimeModel().time_(fromTime);
		calendarTimeIntervalModel.toCalendarTimeModel().time_(toTime);
		return calendarTimeIntervalModel;
	}

	/**
	 * Answer fromCalendarTimeModel.
	 *
	 * @return JunCalendarTimeModel
	 * @category accessing
	 */
	public JunCalendarTimeModel fromCalendarTimeModel() {
		if (fromCalendarTimeModel == null) {
			fromCalendarTimeModel = new JunCalendarTimeModel();
			final JunCalendarTimeIntervalModel this_ = this;
			fromCalendarTimeModel.validateBlock_(new StBlockClosure() {
				public Object value_value_(Object oldTime, Object newTime) {
					return (Object) this_.validateFromTime_with_((Calendar) oldTime, (Calendar) newTime);
				}
			});
		}
		return fromCalendarTimeModel;
	}

	/**
	 * Answer fromCaalendarTimeModel and toCalendarTimeModel.
	 *
	 * @return JunCalendarTimeModel[]
	 * @category accessing
	 */
	public JunCalendarTimeModel[] times() {
		JunCalendarTimeModel[] array = new JunCalendarTimeModel[2];
		array[0] = this.fromCalendarTimeModel();
		array[1] = this.toCalendarTimeModel();
		return array;
	}

	/**
	 * Answer toCalendarTimeModel.
	 *
	 * @return JunCalendarTimeModel
	 * @category accessing
	 */
	public JunCalendarTimeModel toCalendarTimeModel() {
		if (toCalendarTimeModel == null) {
			toCalendarTimeModel = new JunCalendarTimeModel();
			final JunCalendarTimeIntervalModel this_ = this;
			toCalendarTimeModel.validateBlock_(new StBlockClosure() {
				public Object value_value_(Object oldTime, Object newTime) {
					return (Object) this_.validateToTime_with_((Calendar) oldTime, (Calendar) newTime);
				}
			});
		}
		return toCalendarTimeModel;
	}

	/**
	 * Default view.
	 *
	 * @return jp.co.sra.smalltalk.StView
	 * @category defaults
	 */
	public StView defaultView() {
		JunCalendarTimeIntervalView aView;
		if (GetDefaultViewMode() == VIEW_AWT) {
			aView = new JunCalendarTimeIntervalViewAwt(this);
		} else {
			aView = new JunCalendarTimeIntervalViewSwing(this);
		}
		return aView;
	}

	/**
	 * Amswer old time.
	 *
	 * @param oldTime java.util.Calendar
	 * @param newTime java.util.Calendar
	 * @return java.util.Calendar
	 * @category private
	 */
	private Calendar validateFromTime_with_(Calendar oldTime, Calendar newTime) {
		if (newTime.before(this.toCalendarTimeModel().time())) {
			return newTime;
		}
		return this.toCalendarTimeModel().time();
	}

	/**
	 * Amswer latest time.
	 *
	 * @param oldTime java.util.Calendar
	 * @param newTime java.util.Calendar
	 * @return java.util.Calendar
	 * @category private
	 */
	private Calendar validateToTime_with_(Calendar oldTime, Calendar newTime) {
		if (newTime.after(this.fromCalendarTimeModel().time())) {
			return newTime;
		}
		return this.fromCalendarTimeModel().time();
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Period (Time)");
	}
}
