package jp.co.sra.jun.goodies.calendar;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jp.co.sra.smalltalk.StSimpleDialogViewAwt;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunCalendarTimeIntervalDialogViewAwt class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarTimeIntervalDialogViewAwt.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarTimeIntervalDialogViewAwt extends StSimpleDialogViewAwt implements JunCalendarTimeIntervalDialogView {
	protected JunCalendarTimeIntervalViewAwt calendarTimeIntervalView;
	protected Button acceptButton;
	protected Button cancelButton;
	protected JunCalendarTimeViewAwt fromView;
	protected JunCalendarTimeViewAwt toView;

	/**
	 * Create a new instance of <code>JunCalendarTimeIntervalDialogViewAwt</code> and initialize it.
	 * 
	 * @param newCalendarTimeIntervalDialog JunCalendarTimeIntervalDialog
	 * @category Instance creation
	 */
	public JunCalendarTimeIntervalDialogViewAwt(JunCalendarTimeIntervalDialog newCalendarTimeIntervalDialog) {
		super(newCalendarTimeIntervalDialog);
	}

	/**
	 * Answer the default dialog.
	 *
	 * @return java.awt.Dialog
	 * @category accessing
	 */
	public Dialog defaultDialog() {
		Dialog aDialog = new Dialog(new Frame(), this.getCalendarTimeIntervalDialog().windowTitle(), true);
		aDialog.add(this);
		aDialog.pack();
		return aDialog;
	}

	/**
	 * Answer my model as a JunCalendarTimeIntervalDialog.
	 * @return JunCalendarTimeIntervalDialog
	 * @category accessing
	 */
	public JunCalendarTimeIntervalDialog getCalendarTimeIntervalDialog() {
		return (JunCalendarTimeIntervalDialog) this.model();
	}

	/**
	 * Answer my accept button.
	 * @return java.awt.Button
	 * @category accessing
	 */
	protected Button acceptButton() {
		if (acceptButton == null) {
			acceptButton = new Button(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (((Boolean) getCalendarTimeIntervalDialog().acceptButtonPressed()).booleanValue()) {
						getCalendarTimeIntervalDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Build this component.
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fromView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -102, 0.5f, -1));
		this.add(this.toView(), WindowSpecLayout.Position(0f, 1, 0.5f, 1, 1f, -102, 1f, -1));
		this.add(this.cancelButton(), WindowSpecLayout.Position(1f, -96, 0f, 56, 1f, -8, 0f, 88));
		this.add(this.acceptButton(), WindowSpecLayout.Position(1f, -96, 0f, 16, 1f, -8, 0f, 48));
		defaultButton = this.acceptButton();
		this.setSize(250, 400);
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return java.awt.Button
	 * @category accessing
	 */
	protected Button cancelButton() {
		if (cancelButton == null) {
			cancelButton = new Button(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (((Boolean) getCalendarTimeIntervalDialog().cancelButtonPressed()).booleanValue()) {
						getCalendarTimeIntervalDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Answer my calendar date view.
	 *
	 * @return JunCalendarTimeIntervalViewAwt
	 * @category accessing
	 */
	protected JunCalendarTimeIntervalViewAwt calendarTimeIntervalView() {
		if (calendarTimeIntervalView == null) {
			calendarTimeIntervalView = new JunCalendarTimeIntervalViewAwt(this.getCalendarTimeIntervalDialog().calendarTimeIntervalModel());
		}
		return calendarTimeIntervalView;
	}

	/**
	 * Answer from time view.
	 *
	 * @return JunCalendarTimeViewAwt
	 * @category accessing
	 */
	protected JunCalendarTimeViewAwt fromView() {
		if (fromView == null) {
			fromView = new JunCalendarTimeViewAwt(this.getCalendarTimeIntervalDialog().calendarTimeIntervalModel().fromCalendarTimeModel());
		}
		return fromView;
	}

	/**
	 * Answer to time view.
	 *
	 * @return JunCalendarTimeViewAwt
	 * @category accessing
	 */
	protected JunCalendarTimeViewAwt toView() {
		if (toView == null) {
			toView = new JunCalendarTimeViewAwt(this.getCalendarTimeIntervalDialog().calendarTimeIntervalModel().toCalendarTimeModel());
		}
		return toView;
	}
}
