package jp.co.sra.jun.goodies.calendar;

import java.awt.Dialog;
import java.util.Calendar;

import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.*;

/**
 * JunCalendarTimeDialog class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarTimeDialog.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarTimeDialog extends StSimpleDialog {
	protected JunCalendarTimeModel calendarTimeModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;

	/**
	 * Create a new instance of <code>JunCalendarTimeDialog</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunCalendarTimeDialog() {
		super();
	}

	/**
	 * JunCalendarTimeDialog.Request()
	 * 
	 * @return Calendar
	 * @category Utilities
	 */
	public static Calendar Request() {
		return JunCalendarTimeDialog.Request_(null);
	}

	/**
	 * JunCalendarTimeDialog.Request_("Select date.")
	 * 
	 * @param messageString java.lang.String
	 * @return Calendar
	 * @category Utilities
	 */
	public static Calendar Request_(String messageString) {
		return JunCalendarTimeDialog.Request_initialTime_(messageString, Calendar.getInstance());
	}

	/**
	 * JunCalendarTimeDialog.Request_initialTime_("Select date.", Calendar.getInstance());
	 * 
	 * @param messageString java.lang.String
	 * @param aTime java.util.Calendar
	 * @return Calendar
	 * @category Utilities
	 */
	public static Calendar Request_initialTime_(String messageString, Calendar aTime) {
		return JunCalendarTimeDialog.Request_initialTime_onAccept_onCancel_(messageString, aTime, null, null);
	}

	/**
	 * JunCalendarTimeDialog.Request_initialTime_onAccept_onCancel_(
	 * 	"Select date.",
	 *	Calendar.getInstance(),
	 *	null,
	 *	null)
	 *
	 * @param messageString java.lang.String
	 * @param aTime java.util.Calendar
	 * @param anAcceptBlock StBlockClosure
	 * @param aCancelBlock StBlockClosure
	 * @return java.util.Calendar
	 * @category Utilities
	 */
	public static Calendar Request_initialTime_onAccept_onCancel_(String messageString, Calendar aTime, StBlockClosure anAcceptBlock, StBlockClosure aCancelBlock) {
		JunCalendarTimeDialog calendarTimeDialog = new JunCalendarTimeDialog();
		if (!(aTime == null)) {
			calendarTimeDialog.calendarTimeModel_(JunCalendarTimeModel.Time_(aTime));
		}
		Dialog dialog = calendarTimeDialog.allButOpenDialog();
		if (!(messageString == null)) {
			dialog.setTitle(messageString);
		}
		if (!(anAcceptBlock == null)) {
			calendarTimeDialog.acceptBlock_(anAcceptBlock);
		}
		if (!(aCancelBlock == null)) {
			calendarTimeDialog.cancelBlock_(aCancelBlock);
		}
		_ShowAtMousePoint(dialog);
		if (calendarTimeDialog.accept()._booleanValue()) {
			return calendarTimeDialog.calendarTimeModel().time();
		} else {
			return null;
		}
	}

	/**
	 * Set an action accept to a block..
	 * @param aBlock StBlockClosure
	 * @category accessing
	 */
	public void acceptBlock_(StBlockClosure aBlock) {
		acceptBlock = aBlock;
	}

	/**
	 * Return a JunCalendarTimeModel instance.
	 * @return JunCalendarTimeModel
	 * @category accessing
	 */
	public JunCalendarTimeModel calendarTimeModel() {
		if (calendarTimeModel == null) {
			calendarTimeModel = new JunCalendarTimeModel();
		}
		return calendarTimeModel;
	}

	/**
	 * Set new insntace of JunCalendarTimeModel.
	 * @param aCalendarTimeModel JunCalendarTimeModel
	 * @category accessing
	 */
	public void calendarTimeModel_(JunCalendarTimeModel aCalendarTimeModel) {
		calendarTimeModel = aCalendarTimeModel;
	}

	/**
	 * Set a calcel action to a block.
	 * @param aBlock StBlockClosure
	 * @category accessing
	 */
	public void cancelBlock_(StBlockClosure aBlock) {
		cancelBlock = aBlock;
	}

	/**
	 * Return result of accept button pressed.
	 * @return boolean
	 * @category actions
	 */
	public Object acceptButtonPressed() {
		if (!(acceptBlock == null)) {
			return acceptBlock.value_(this.calendarTimeModel());
		}
		return new Boolean(true);
	}

	/**
	 * Return result of cancel button pressed.
	 * @return boolean
	 * @category actions
	 */
	public Object cancelButtonPressed() {
		if (!(cancelBlock == null)) {
			return cancelBlock.value_(this.calendarTimeModel());
		}
		return new Boolean(true);
	}

	/**
	 * Answer a default view.
	 *
	 * @return jp.co.sra.smalltalk.StView
	 * @category accessing
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunCalendarTimeDialogViewAwt(this);
		} else {
			return new JunCalendarTimeDialogViewSwing(this);
		}
	}

	/**
	 * Initialize the ApplicationModel when created.
	 *
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		acceptBlock = null;
		cancelBlock = null;
	}

	/**
	 * Answer a window title.
	 *
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Time Dialog");
	}
}
