package jp.co.sra.jun.goodies.calendar;

import java.awt.Dimension;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunCalendarDateIntervalViewSwing class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateIntervalViewSwing.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateIntervalViewSwing extends JunAbstractViewJPanel implements JunCalendarDateIntervalView {

	protected JunCalendarDateViewSwing fromView;
	protected JunCalendarDateViewSwing toView;

	/**
	 * Create a new instance of <code>JunCalendarDateIntervalViewSwing</code> and initialize it.
	 * 
	 * @param aCalendarDateIntervalModel JunCalendarDateIntervalModel
	 * @category Instance creation
	 */
	public JunCalendarDateIntervalViewSwing(JunCalendarDateIntervalModel aCalendarDateIntervalModel) {
		super(aCalendarDateIntervalModel);
	}

	/**
	 * Answer a fromView.
	 *
	 * @return JunCalendarDateViewSwing
	 * @category accessing
	 */
	public JunCalendarDateViewSwing fromView() {
		if (fromView == null) {
			fromView = new JunCalendarDateViewSwing(this.getModel().fromCalendarDateModel());
		}
		return fromView;
	}

	/**
	 * Answer a toView.
	 *
	 * @return JunCalendarDateViewSwing
	 * @category accessing
	 */
	public JunCalendarDateViewSwing toView() {
		if (toView == null) {
			toView = new JunCalendarDateViewSwing(this.getModel().toCalendarDateModel());
		}
		return toView;
	}

	/**
	 * Get model.
	 *
	 * @return JunCalendarDateModel
	 * @category accessing
	 */
	public JunCalendarDateIntervalModel getModel() {
		return (JunCalendarDateIntervalModel) this.model();
	}

	/**
	 * Build this component.
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fromView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0.5f, -1));
		this.add(this.toView(), WindowSpecLayout.Position(0f, 1, 0.5f, 1, 1f, -1, 1f, -1));
		this.setPreferredSize(new Dimension(300, 400));
	}

}
