package jp.co.sra.jun.goodies.calendar;

import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunCalendarDateAndTimeViewAwt class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateAndTimeViewAwt.java,v 8.11 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateAndTimeViewAwt extends JunAbstractViewPanel implements JunCalendarDateAndTimeView {

	protected JunCalendarDateViewAwt dateView;
	protected JunCalendarTimeViewAwt timeView;

	/**
	 * Create a new instance of <code>JunCalendarDateAndTimeViewAwt</code> and initialize it.
	 * 
	 * @param aCalendarDateAndTimeModel JunCalendarDateAndTimeModel
	 * @category Instance creation
	 */
	public JunCalendarDateAndTimeViewAwt(JunCalendarDateAndTimeModel aCalendarDateAndTimeModel) {
		super(aCalendarDateAndTimeModel);
	}

	/**
	 * Answer my date view.
	 *
	 * @return JunCalendarDateViewAwt
	 * @category accessing
	 */
	public JunCalendarDateViewAwt dateView() {
		if (dateView == null) {
			dateView = new JunCalendarDateViewAwt(this.getModel().calendarDateModel());
		}
		return dateView;
	}

	/**
	 * Answer my time view.
	 *
	 * @return JunCalendarTimeViewAwt
	 * @category accessing
	 */
	public JunCalendarTimeViewAwt timeView() {
		if (timeView == null) {
			timeView = new JunCalendarTimeViewAwt(this.getModel().calendarTimeModel());
		}
		return timeView;
	}

	/**
	 * Get model.
	 * @category accessing
	 *
	 * @return JunCalendarTimeModel
	 */
	public JunCalendarDateAndTimeModel getModel() {
		return (JunCalendarDateAndTimeModel) this.model();
	}

	/**
	 * Build this component.
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.dateView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 0.67f, 0, 1f, -1));
		this.add(this.timeView(), WindowSpecLayout.Position(0.67f, 0, 0f, 1, 1f, -1, 1f, -1));
		this.setSize(450, 200);
	}

}
