package jp.co.sra.jun.goodies.calendar;

import java.awt.event.WindowEvent;
import java.util.Calendar;

import jp.co.sra.jun.goodies.milliseconds.JunMillisecondModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StBlockValued;
import jp.co.sra.smalltalk.StView;

/**
 * JunCalendarClockDateAndTime class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarClockDateAndTime.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarClockDateAndTime extends JunCalendarModel implements StBlockValued {
	protected Thread clockProcess;
	protected JunCalendarDateModel calendarDateModel;
	protected JunCalendarTimeModel calendarTimeModel;
	protected boolean active;

	/**
	 * Create instance and initialize.
	 * @category Instance creation
	 */
	public JunCalendarClockDateAndTime() {
		super();
	}

	/**
	 * Initialize.
	 * @category initialize-release
	 */
	public void initialize() {
		this.resumeClockProcess();
	}

	/**
	 * Release.
	 * @category initialize-release
	 */
	public void release() {
		this.terminateClockProcess();
	}

	/**
	 * Answer a calendarDateModel.
	 *
	 * @return JunCalendarDateModel
	 * @category accessing
	 */
	public JunCalendarDateModel calendarDateModel() {
		if (calendarDateModel == null) {
			calendarDateModel = new JunCalendarDateModel();
		}
		return calendarDateModel;
	}

	/**
	 * Answer a calendarTimeModel.
	 *
	 * @return JunCalendarTimeModel
	 * @category accessing
	 */
	public JunCalendarTimeModel calendarTimeModel() {
		if (calendarTimeModel == null) {
			calendarTimeModel = new JunCalendarTimeModel();
		}
		return calendarTimeModel;
	}

	/**
	 * Answer current date.
	 *
	 * @return java.util.Calendar
	 * @category accessing
	 */
	public Object value() {
		return (Object) Calendar.getInstance();
	}

	/**
	 * Compute aBlock.
	 *
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.smalltalk.StBlockValue
	 * @category accessing
	 */
	public StBlockValue compute_(StBlockClosure aBlock) {
		return new StBlockValue(aBlock, this);
	}

	/**
	 * Invoked when a window is in the process of being closed.
	 * 
	 * @param e java.awt.event.WindowEvent
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#noticeOfWindowClose(java.awt.event.WindowEvent)
	 * @category interface closing
	 */
	public void noticeOfWindowClose(WindowEvent e) {
		this.release();
		super.noticeOfWindowClose(e);
	}

	/**
	 * Answer next milli second clock.
	 *
	 * @return java.lang.Integer
	 * @category accessing
	 */
	public long nextMillisecondClockValue() {
		JunMillisecondModel now = new JunMillisecondModel();
		now.nowValue();
		return now.milliseconds() + 1000;
	}

	/**
	 * Resume clock process.
	 * @category private
	 */
	private void resumeClockProcess() {
		if (clockProcess != null) {
			try {
				clockProcess.join();
			} catch (java.lang.InterruptedException e) {
			}
		}
		this.active_(true);
		final JunCalendarClockDateAndTime this_ = this;
		clockProcess = new Thread() {
			public void run() {
				while (this_.isActive()) {
					try {
						Thread.sleep(1000);
					} catch (InterruptedException e) {
					}
					this_.updateDateAndTime();
				}
			}
		};
		clockProcess.setPriority(Thread.NORM_PRIORITY);
		clockProcess.start();
	}

	/**
	 * Treminate clock process.
	 * @category private
	 */
	private void terminateClockProcess() {
		if (clockProcess != null) {
			try {
				this.active_(false);
				clockProcess.join();
			} catch (java.lang.InterruptedException e) {
				System.out.println("faild to stop process" + e);
			}
		}
		clockProcess = null;
	}

	/**
	 * Update date and time.
	 * @category private
	 */
	private void updateDateAndTime() {
		this.calendarDateModel().date_(Calendar.getInstance());
		this.calendarTimeModel().time_(Calendar.getInstance());
		this.changed_($("value"));
	}

	/**
	 * Default view.
	 *
	 * @return jp.co.sra.smalltalk.StView
	 * @category defaults
	 */
	public StView defaultView() {
		JunCalendarClockDateAndTimeView aView;
		if (GetDefaultViewMode() == VIEW_AWT) {
			aView = new JunCalendarClockDateAndTimeViewAwt(this);
		} else {
			aView = new JunCalendarClockDateAndTimeViewSwing(this);
		}
		return aView;
	}

	/**
	 * Return window title.
	 *
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Date and Time");
	}

	/**
	 * Answer active or not.
	 *
	 * @return boolean
	 * @category testing
	 */
	public boolean isActive() {
		return active;
	}

	/**
	 * Set active.
	 * @category accessing
	 *
	 * @param aBoolean boolean
	 */
	public void active_(boolean aBoolean) {
		active = aBoolean;
	}

	/**
	 * Return date and time.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StObject#toString()
	 * @category printing
	 */
	public java.lang.String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append(this.calendarDateModel().toString());
		buf.append(" ");
		buf.append(this.calendarTimeModel().toString());
		return buf.toString();
	}
}
