package jp.co.sra.jun.goodies.button;

import java.awt.Image;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuEvent;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StMenuItemView;
import jp.co.sra.smalltalk.menu.StPopupMenu;

/**
 * JunButtonWithMenuModel class
 * 
 *  @author    nisinaka
 *  @created   2006/01/27 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun580 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunButtonWithMenuModel.java,v 8.11 2008/02/20 06:31:11 nisinaka Exp $
 */
public class JunButtonWithMenuModel extends JunButtonModel {

	protected StMenu buttonMenu;
	protected StValueHolder selectedMenuItemHolder;
	protected boolean visualChanging;
	protected boolean markerDisplaying;

	/**
	 * Create a new instance of JunButtonWithMenuModel and initialize it.
	 *
	 * @param aBoolean boolean
	 * @param anAction jp.co.sra.smalltalk.StBlockClosure
	 * @param aMenu jp.co.sra.smalltalk.menu.StMenu
	 * @param aMenuItem jp.co.sra.smalltalk.menu.StMenuItem
	 * @category Instance creation
	 */
	public JunButtonWithMenuModel(boolean aBoolean, StBlockClosure anAction, StMenu aMenu, StMenuItem aMenuItem) {
		super(aBoolean, null, anAction);

		this.menu_(aMenu);
		this.selectedMenuItem_(aMenuItem);
	}

	/**
	 * Create a new instance of JunButtonWithMenuModel and initialize it.
	 *
	 * @param labels java.lang.Object[]
	 * @param labelImages java.awt.Image[]
	 * @param values java.lang.Object[]
	 * @category Instance creation
	 */
	public JunButtonWithMenuModel(Object[] labels, Image[] labelImages, Object[] values) {
		super(false, null, new StBlockClosure() {
			public Object value_(Object anObject) {
				JunButtonWithMenuModel model = (JunButtonWithMenuModel) anObject;
				model.value_(!model.value());
				return null;
			}
		});

		if (labels != null && labelImages != null && values != null) {
			int size = Math.min(labels.length, Math.min(labelImages.length, values.length));
			if (size > 0) {
				StMenu aMenu = new StMenu();
				for (int i = 0; i < size; i++) {
					StCheckBoxMenuItem aMenuItem = new StCheckBoxMenuItem(labels[i]);
					aMenuItem.labelImage_(labelImages[i]);
					aMenuItem.value_(values[i]);
					aMenu.add(aMenuItem);
				}
				this.menu_(aMenu);
				this.selectedMenuItem_(aMenu.menuItems()[0]);
			}
		}
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		buttonMenu = null;
		selectedMenuItemHolder = null;
		visualChanging = true;
		markerDisplaying = true;
	}

	/**
	 * Answer my current menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenu
	 * @category accessing
	 */
	public StMenu menu() {
		return buttonMenu;
	}

	/**
	 * Set my new menu.
	 * 
	 * @param aMenu jp.co.sra.smalltalk.menu.StMenu
	 * @category accessing
	 */
	public void menu_(StMenu aMenu) {
		if (aMenu == null) {
			return;
		}
		if (aMenu.menuItems().length == 0) {
			return;
		}

		this._setMenu(aMenu);
		this.repeatAction_(true);
		this.repeatTick_(500);

		if (displayObject == null) {
			this.selectedMenuItem_(aMenu.menuItems()[0]);
		}
	}

	/**
	 * Set the menu.
	 * 
	 * @param aMenu jp.co.sra.smalltalk.menu.StMenu
	 * @category accessing
	 */
	protected void _setMenu(StMenu aMenu) {
		if (aMenu != null) {
			StMenuItem[] menuItems = aMenu.menuItems();
			for (int i = 0; i < menuItems.length; i++) {
				menuItems[i].addMenuListener(new MenuListener() {
					public void menuPerformed(MenuEvent aMenuEvent) {
						StMenuItemView menuItemView = (StMenuItemView) aMenuEvent.getSource();
						JunButtonWithMenuModel.this.selectedMenuItem_(menuItemView.getMenuItem());
					}
				});
			}
		}

		buttonMenu = aMenu;
	}

	/**
	 * Answer my current selected menu item.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuItem
	 * @category accessing
	 */
	public StMenuItem selectedMenuItem() {
		return (StMenuItem) this.selectedMenuItemHolder().value();
	}

	/**
	 * Set my new selected menu item.
	 * 
	 * @param aMenuItem jp.co.sra.smalltalk.menu.StMenuItem
	 * @category accessing
	 */
	public void selectedMenuItem_(StMenuItem aMenuItem) {
		if (this.selectedMenuItem() == aMenuItem) {
			return;
		}

		this.selectedMenuItemHolder().value_(aMenuItem);
		this.visualChange();
	}

	/**
	 * Answer the value holder for the selected menu item.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category accessing
	 */
	public StValueHolder selectedMenuItemHolder() {
		if (selectedMenuItemHolder == null) {
			selectedMenuItemHolder = new StValueHolder();
		}
		return selectedMenuItemHolder;
	}

	/**
	 * Answer true if the receiver is specified to be changing its visual according to the menu selection.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean visualChanging() {
		return visualChanging;
	}

	/**
	 * Set whether the receiver should change its visual according to the menu selection or not.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void visualChanging_(boolean aBoolean) {
		visualChanging = aBoolean;
		this.visualChange();
	}

	/**
	 * Answer true if the receiver is specified to display a marker for the menu selection.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean markerDisplaying() {
		return markerDisplaying;
	}

	/**
	 * Set whether the receiver should display a marker for the menu selection or not.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void markerDisplaying_(boolean aBoolean) {
		markerDisplaying = aBoolean;
		this.changed();
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunButtonWithMenuViewAwt(this);
		} else {
			return new JunButtonWithMenuViewSwing(this);
		}
	}

	/**
	 * Answer my popup menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StPopupMenu
	 * @see jp.co.sra.smalltalk.StApplicationModel#_popupMenu()
	 * @category resources
	 */
	public StPopupMenu _popupMenu() {
		if (this.menu() == null) {
			return null;
		}

		StPopupMenu popupMenu = new StPopupMenu();
		popupMenu.addAll(this.menu().menuItems());
		return popupMenu;
	}

	/**
	 * Change my visual.
	 * 
	 * @category private
	 */
	protected void visualChange() {
		if (this.menu() == null) {
			return;
		}
		if (this.selectedMenuItem() == null) {
			return;
		}

		StMenuItem menuItem = this.selectedMenuItem();
		if (menuItem == null) {
			return;
		}

		StMenuItem[] menuItems = this.menu().menuItems();
		for (int i = 0; i < menuItems.length; i++) {
			if (menuItems[i] instanceof StCheckBoxMenuItem) {
				((StCheckBoxMenuItem) menuItems[i]).beOff();
			}
		}
		if (menuItem instanceof StCheckBoxMenuItem) {
			((StCheckBoxMenuItem) menuItem).beOn();
		}

		if (this.visualChanging()) {
			Image labelImage = menuItem.labelImage();
			if (labelImage == null) {
				this.visual_(menuItem.label());
			} else {
				this.visual_(labelImage);
			}
		}
	}

}
