package jp.co.sra.jun.goodies.button;

import java.awt.event.MouseEvent;

import javax.swing.SwingUtilities;

/**
 * JunButtonWithMenuController class
 * 
 *  @author    nisinaka
 *  @created   2006/01/27 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun541 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunButtonWithMenuController.java,v 8.10 2008/02/20 06:31:11 nisinaka Exp $
 */
public class JunButtonWithMenuController extends JunButtonController {

	/**
	 * Invoked when a mouse button has been pressed on a component.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mousePressed(MouseEvent e) {
		_mousePressed = false;

		if (e.isPopupTrigger()) {
			this._showPopupMenu();
		} else {
			Thread aThread = new Thread() {
				public void run() {
					_mousePressed = true;
					long time = System.currentTimeMillis() + getButtonModel().repeatTick();
					while (System.currentTimeMillis() < time) {
						if (_mousePressed == false) {
							return;
						}

						Thread.yield();
					}

					_mousePressed = false;
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {
							_showPopupMenu();
						}
					});
				}
			};
			aThread.setPriority(Thread.NORM_PRIORITY - 1);
			aThread.start();
		}
	}

	/**
	 * Invoked when a mouse button has been released on a component.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mouseReleased(MouseEvent e) {
		if (e.isPopupTrigger()) {
			this._showPopupMenu();
		} else {
			if (_mousePressed) {
				_mousePressed = false;
				this.executeAction();
			}
		}
	}

	/**
	 * Show the popup menu.
	 * 
	 * @category private
	 */
	protected void _showPopupMenu() {
		this.view()._showPopupMenu(0, 0);
	}

}
