package jp.co.sra.jun.goodies.button;

import java.awt.Color;
import java.awt.Graphics;

import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunButtonView interface
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/11/12 (by MATSUDA Ryouichi)
 *  @updated   2002/11/21 (by nisinaka)
 *  @updated   2003/03/24 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunButtonView.java,v 8.10 2008/02/20 06:31:11 nisinaka Exp $
 */
public interface JunButtonView extends JunAbstractView {

	public static final Color Gray20 = new Color((float) 0.2, (float) 0.2, (float) 0.2);
	public static final Color Gray30 = new Color((float) 0.3, (float) 0.3, (float) 0.3);
	public static final Color Gray70 = new Color((float) 0.7, (float) 0.7, (float) 0.7);
	public static final Color Gray80 = new Color((float) 0.8, (float) 0.8, (float) 0.8);
	public static final Color Gray90 = new Color((float) 0.9, (float) 0.9, (float) 0.9);

	/**
	 * Answer my model as JunButtonModel.
	 * 
	 * @return jp.co.sra.jun.goodies.JunButtonModel
	 * @category accessing
	 */
	public JunButtonModel getButtonModel();

	/**
	 * Update the view when the value of the model is true.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	public void displayTrueOn_(Graphics aGraphics);

	/**
	 * Update the view when the value of the model is false.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	public void displayFalseOn_(Graphics aGraphics);

}
