package jp.co.sra.jun.goodies.button;

import java.awt.Dimension;
import java.awt.Image;

import javax.swing.ImageIcon;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.system.framework.JunApplicationModel;

/**
 * JunButtonModel class
 * 
 *  @author    He Weijie
 *  @created   1998/08/13 (by He Weijie)
 *  @updated   1999/11/12 (by MATSUDA Ryouichi)
 *  @updated   2002/10/31 (by nisinaka)
 *  @updated   2002/11/21 (by nisinaka)
 *  @updated   2003/03/24 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunButtonModel.java,v 8.10 2008/02/20 06:31:11 nisinaka Exp $
 */
public class JunButtonModel extends JunApplicationModel {

	/** A boolean value as a button model. */
	protected boolean buttonValue;

	/** An object which will be displayed on an associated view. */
	protected StDisplayable displayObject;

	/** An action which will be evaluated when a button is pressed. */
	protected StBlockClosure buttonAction;

	/** A flag to allow a repeat action or not. */
	protected boolean repeatAction;

	/** A number in millisecond to control the repeat action. */
	protected int repeatTick;

	/** A flag whether the button is currently active or not. */
	protected boolean activeState;

	protected boolean _isPressedWithShiftDown;

	/**
	 * Create a new instance of JunButtonModel and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunButtonModel() {
		super();
	}

	/**
	 * Create a new instance of JunButtonModel and initialize it.
	 * 
	 * @param newValue boolean
	 * @param newVisual java.awt.Image
	 * @param newAction jp.co.sra.smalltalk.StBlockClosure
	 * @category Instance creation
	 */
	public JunButtonModel(boolean newValue, Object newVisual, StBlockClosure newAction) {
		super();
		this.value_(newValue);
		this.visual_(newVisual);
		this.action_(newAction);
	}

	/**
	 * Create a new instance of JunButtonModel.
	 * 
	 * @param aClass java.lang.Class
	 * @param aBoolean boolean
	 * @param anImage java.awt.Image
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.jun.goodies.button.JunButtonModel
	 * @deprecated since Jun357, use the constructor
	 * @category Instance creation
	 */
	public static JunButtonModel Value_visual_action_(Class aClass, boolean aBoolean, Image anImage, StBlockClosure aBlock) {
		JunButtonModel buttonModel = (JunButtonModel) _New(aClass);
		buttonModel.value_(aBoolean);
		buttonModel.visual_(anImage);
		buttonModel.action_(aBlock);
		return buttonModel;
	}

	/**
	 * Create a new instance of JunButtonModel.
	 * 
	 * @param aClass java.lang.Class
	 * @param aBoolean boolean
	 * @param anObject java.lang.Object
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.jun.goodies.button.JunButtonModel
	 * @deprecated since Jun357, use the constructor
	 * @category Instance creation
	 */
	public static JunButtonModel Value_visual_action_(Class aClass, boolean aBoolean, Object anObject, StBlockClosure aBlock) {
		JunButtonModel buttonModel = (JunButtonModel) _New(aClass);
		buttonModel.value_(aBoolean);
		buttonModel.visual_(anObject);
		buttonModel.action_(aBlock);
		return buttonModel;
	}

	/**
	 * Create a new instance of JunButtonModel.
	 * 
	 * @param aBoolean boolean
	 * @param anImage java.awt.Image
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.jun.goodies.button.JunButtonModel
	 * @deprecated since Jun357, use the constructor
	 * @category Instance creation
	 */
	public static JunButtonModel Value_visual_action_(boolean aBoolean, Image anImage, StBlockClosure aBlock) {
		return new JunButtonModel(aBoolean, anImage, aBlock);
	}

	/**
	 * Create a new instance of JunButtonModel.
	 * 
	 * @param aBoolean boolean
	 * @param anObject java.lang.Object
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.jun.goodies.button.JunButtonModel
	 * @deprecated since Jun357, use the constructor
	 * @category Instance creation
	 */
	public static JunButtonModel Value_visual_action_(boolean aBoolean, Object anObject, StBlockClosure aBlock) {
		return new JunButtonModel(aBoolean, anObject, aBlock);
	}

	/**
	 * Initialize the JunButtonModel.
	 * 
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		buttonValue = false;
		displayObject = null;
		buttonAction = null;
		repeatAction = false;
		repeatTick = 500;
		activeState = true;
		_isPressedWithShiftDown = false;
	}

	/**
	 * Just return the current button value.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean value() {
		return buttonValue;
	}

	/**
	 * Set the new button value. If the value is changed, announce it.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void value_(boolean aBoolean) {
		if (aBoolean != buttonValue) {
			buttonValue = aBoolean;
			this.changed_($("value"));
		}
	}

	/**
	 * Return the current display object. If not assigned yet, set an empty
	 * string as a fake display object and return it.
	 * 
	 * @return jp.co.sra.smalltalk.StDisplayable
	 * @category accessing
	 */
	public StDisplayable visual() {
		if (displayObject == null) {
			this.visual_(new String());
		}
		return displayObject;
	}

	/**
	 * Set a new visual object. 
	 * If the visual object is changed, announce it.
	 * 
	 * @param anObject java.lang.Object
	 * @category accessing
	 */
	public void visual_(Object anObject) {
		Object visual = anObject;
		if (visual != displayObject) {
			if (visual == null) {
				displayObject = new StComposedText(new String());
			} else if (visual instanceof StDisplayable) {
				displayObject = (StDisplayable) visual;
			} else if (visual instanceof Image) {
				displayObject = new StImage((Image) visual);
			} else if (visual instanceof ImageIcon) {
				displayObject = new StImage(((ImageIcon) visual).getImage());
			} else {
				String aString = (anObject instanceof String) ? (String) anObject : anObject.toString();
				displayObject = new StComposedText(aString);
			}
			this.changed_($("visual"));
		}
	}

	/**
	 * Return the current button action. If not assigned, create a fake action and return it.
	 * 
	 * @return jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public StBlockClosure action() {
		if (buttonAction == null) {
			this.action_(new StBlockClosure());
		}
		return buttonAction;
	}

	/**
	 * Set the action.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public void action_(StBlockClosure aBlock) {
		buttonAction = aBlock;
	}

	/**
	 * Just return the repeatAction.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean repeatAction() {
		return repeatAction;
	}

	/**
	 * Set the repeatAction.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void repeatAction_(boolean aBoolean) {
		repeatAction = aBoolean;
	}

	/**
	 * Answer the repeat tick in milliseconds.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int repeatTick() {
		return repeatTick;
	}

	/**
	 * Set the repeat tick in milliseconds.
	 * 
	 * @param milliseconds int
	 * @category accessing
	 */
	public void repeatTick_(int milliseconds) {
		repeatTick = milliseconds;
	}

	/**
	 * Answer true if the mouse pressed with the shift key down, otherwise false.
	 *
	 * @return boolean
	 * @category accessing
	 */
	public boolean _isPressedWithShiftDown() {
		return _isPressedWithShiftDown;
	}

	/**
	 * Set whether the shift key is down when the button is pressed with the mouse.
	 *
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void _isPressedWithShiftDown(boolean aBoolean) {
		_isPressedWithShiftDown = aBoolean;
	}

	/**
	 * Make the button disable.
	 * 
	 * @category accessing
	 */
	public void disable() {
		activeState = false;
		this.changed_($("visual"));
	}

	/**
	 * Make the button enable.
	 * 
	 * @category accessing
	 */
	public void enable() {
		activeState = true;
		this.changed_($("visual"));
	}

	/**
	 * Answer true if the button is currently active, otherwise false.
	 *
	 * @return boolean
	 * @category testing
	 */
	public boolean isActive() {
		return activeState;
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Button");
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunButtonViewAwt(this, new Dimension(100, 100));
		} else {
			return new JunButtonViewSwing(this, new Dimension(100, 100));
		}
	}

	/**
	 * Answer one of my views.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#getView()
	 * @category private
	 */
	public StView getView() {
		Object[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunButtonView && ((JunButtonView) dependents[i]).model() == this) {
				return (JunButtonView) dependents[i];
			}
		}

		return null;
	}

}
