package jp.co.sra.jun.goodies.animation;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.goodies.image.streams.JunGifAnimationStream;
import jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCartoonMovieTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2004/02/05 (By Nobuto Matsubara)
 *  @updated   2007/11/05 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun723 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCartoonMovieTestExamples.java,v 8.13 2008/02/20 06:31:11 nisinaka Exp $
 */
public class JunCartoonMovieTestExamples extends JunTestExamples {

	/**
	 * Example0:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example0() {
		JunCartoonMovie cartoonMovie = new JunCartoonMovie();
		cartoonMovie.openLightWeightWindowSpecAt_fitFlag_markerFlag_(new Point(200, 300), false, false);

		return true;
	}

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunCartoonMovie cartoonMovie = new JunCartoonMovie();
		cartoonMovie.addImage_keepTime_(StImage._OfArea(new Rectangle(0, 0, 400, 300)), 3000);
		cartoonMovie.addImage_keepTime_(StImage._OfArea(new Rectangle(10, 10, 400, 300)), 2000);
		cartoonMovie.addImage_keepTime_(StImage._OfArea(new Rectangle(20, 20, 400, 300)), 1000);
		cartoonMovie.open();

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunCartoonMovie cartoonMovie = new JunCartoonMovie();
		cartoonMovie.addImage_keepTime_(StImage._OfArea(new Rectangle(0, 0, 512, 384)), 1000);
		cartoonMovie.addImage_keepTime_(StImage._OfArea(new Rectangle(10, 10, 512, 384)), 2000);
		cartoonMovie.addImage_keepTime_(StImage._OfArea(new Rectangle(20, 20, 512, 384)), 3000);
		cartoonMovie.addImage_keepTime_(StImage._OfArea(new Rectangle(30, 30, 512, 384)), 4000);
		cartoonMovie.displayName_("Sample");
		cartoonMovie.open();

		return true;
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory($String("Select a directory."));
		if (aDirectory == null) {
			return false;
		}

		String aString = "*.jpg";
		int aNumber = 15;

		try {
			JunCartoonMovie cartoonMovie = new JunCartoonMovie(aDirectory, aString, aNumber);
			cartoonMovie.open();
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}

		return true;
	}

	/**
	 * Example4: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory($String("Select a directory."));
		if (aDirectory == null) {
			return false;
		}

		String aString = "*.jpg";
		int aNumber = 15;
		File aFile = new File("ImageSequence.mov");

		try {
			JunCartoonMovie.ImageSequenceDirectory_jpegImageFileNamePattern_framesPerSecond_movieFile_(aDirectory, aString, aNumber, aFile);
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}

		JunMoviePlayer aMoviePlayer = new JunMoviePlayer(aFile);
		aMoviePlayer.open();

		return true;
	}

	/**
	 * Example5: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		JunCartoonMovie cartoonMovie = new JunCartoonMovie();
		int tickTime = 125;
		Rectangle box = new Rectangle(0, 0, 320, 240);
		Point offset = new Point(10, 10);
		for (int i = 0; i < 20; i++) {
			StImage anImage = StImage._OfArea(box);
			cartoonMovie.addImage_keepTime_(anImage, tickTime);
			box.translate(offset.x, offset.y);
		}
		for (int i = 0; i < 20; i++) {
			box.translate(-offset.x, -offset.y);
			StImage anImage = StImage._OfArea(box);
			cartoonMovie.addImage_keepTime_(anImage, tickTime);
		}

		cartoonMovie.loopPlay();
		cartoonMovie.openAndPlay();

		return true;
	}

	/**
	 * Example6:
	 * 
	 * @return boolean
	 * @throws IOException 
	 * @category Examples
	 */
	public static boolean Example6() {
		JunCartoonMovie cartoonMovie = new JunCartoonMovie();
		int tickTime = 125; // 8Hz

		try {
			StImage[] sampleImages = SampleImages();
			for (int i = 0; i < sampleImages.length; i++) {
				cartoonMovie.addImage_keepTime_(sampleImages[i], tickTime);
			}
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}

		cartoonMovie.loopPlay();
		cartoonMovie.openLightWeightWindowSpec();
		cartoonMovie.start();

		return true;
	}

	/**
	 * Answer the sample images.
	 * 
	 * @return jp.co.sra.smalltalk.StImage[]
	 * @throws IOException 
	 * @category Sample images.
	 */
	protected static StImage[] SampleImages() throws IOException {
		ArrayList images = new ArrayList();

		JunGifAnimationStream stream = null;
		try {
			InputStream in = Object.class.getResourceAsStream("/jp/co/sra/jun/goodies/animation/SampleImage.gif");
			stream = (JunGifAnimationStream) JunGifAnimationStream.On_(in);

			StImage anImage = null;
			while ((anImage = stream.nextImage()) != null) {
				images.add(anImage);
			}

		} finally {
			if (stream != null) {
				stream.close();
			}
		}

		return (StImage[]) images.toArray(new StImage[images.size()]);
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(String argv[]) {
		new JunCartoonMovieTestExamples();
	}

}
