package jp.co.sra.jun.geometry.transformations;

import java.io.IOException;
import java.io.Writer;

import jp.co.sra.jun.collections.sequences.JunDoubleMatrix;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;

/**
 * JunTransformation class
 * 
 *  @author    nisinaka
 *  @created   1998/09/28 (by nisinaka)
 *  @updated   2000/01/06 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTransformation.java,v 8.12 2008/02/20 06:31:11 nisinaka Exp $
 */
public abstract class JunTransformation extends JunGeometry {

	/**
	 * Print my storable string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#storeOn_(java.io.Writer)
	 * @category printing
	 */
	public void storeOn_(Writer aWriter) throws IOException {
		aWriter.write('(');
		aWriter.write(this._className().toString());
		aWriter.write(" fromArray: ");
		aWriter.write("#(");
		double[] array = this.asArray();
		if (array.length > 0) {
			aWriter.write(String.valueOf(array[0]));
		}
		for (int i = 1; i < array.length; i++) {
			aWriter.write(' ');
			aWriter.write(String.valueOf(array[i]));
		}
		aWriter.write(')');
		aWriter.write(')');
	}

	/**
	 * Convert this transformation as an array.
	 * 
	 * @return double[]
	 * @category converting
	 */
	public abstract double[] asArray();

	/**
	 * Convert this transformation as a matrix.
	 * 
	 * @return jp.co.sra.jun.collections.sequences.JunDoubleMatrix
	 * @category converting
	 */
	public abstract JunDoubleMatrix asMatrix();

	/**
	 * Answer the inverse of this transformation.
	 * 
	 * @return jp.co.sra.jun.geometry.transformations.JunTransformation
	 * @category transforming functions
	 */
	public abstract JunTransformation _inverse();

}
