package jp.co.sra.jun.geometry.surfaces;

import jp.co.sra.jun.collections.sequences.JunDoubleMatrix;
import jp.co.sra.jun.collections.sequences.JunMatrix;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunNurbsSurfaceTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/06/12 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun582 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNurbsSurfaceTestExamples.java,v 8.10 2008/02/20 06:30:58 nisinaka Exp $
 */
public class JunNurbsSurfaceTestExamples extends JunTestExamples {

	/**
	 * Example_BSplineSurface:
	 * 
	 * @return boolean
	 */
	public static boolean Example_BSplineSurface() {
		JunNurbsSurface aNurbsSurface = ExampleBSplineSurface();
		aNurbsSurface.asJunOpenGL3dNurbsSurface().show();
		return true;
	}

	/**
	 * Example_NurbsSurface:
	 * 
	 * @return boolean
	 */
	public static boolean Example_NurbsSurface() {
		JunNurbsSurface aNurbsSurface = ExampleNurbsSurface();
		aNurbsSurface.asJunOpenGL3dNurbsSurface().show();
		return true;
	}

	/**
	 * Create an instance of JunOpenGL3dNurbsSurface which represents a B-Spline surface.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsSurface
	 */
	protected static JunNurbsSurface ExampleBSplineSurface() {
		JunMatrix controlPoints = new JunMatrix(4);
		for (int i = 0; i < 4; i++) {
			for (int j = 0; j < 4; j++) {
				double x = ((i - 1.5) * 2) / 3;
				double y = ((j - 1.5) * 2) / 3;
				double z = ((i == 1 || i == 2) && (j == 1 || j == 2)) ? 1 : -1;
				controlPoints._put(i, j, new Jun3dPoint(x, y, z));
			}
		}
		double[] knots = { 0.0, 0.0, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0 };

		return JunNurbsSurface.BSplineControlPoints_uKnotVector_vKnotVector_(controlPoints, knots, knots);
	}

	/**
	 * Create an instance of JunOpenGL3dNurbsSurface which represents a NURBS surface.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsSurface
	 */
	protected static JunNurbsSurface ExampleNurbsSurface() {
		JunMatrix controlPoints = new JunMatrix(4);
		for (int i = 0; i < 4; i++) {
			for (int j = 0; j < 4; j++) {
				double x = ((i - 1.5) * 2) / 3;
				double y = ((j - 1.5) * 2) / 3;
				double z = ((i == 1 || i == 2) && (j == 1 || j == 2)) ? 1 : -1;
				controlPoints._put(j, i, new Jun3dPoint(x, y, z));
			}
		}
		double[] weights = new double[16];
		for (int i = 0; i < 16; i++) {
			weights[i] = ((i + 1) / 4 + 1) / 2.0;
		}
		double[] knots = { 0, 0, 1, 1, 2, 2, 2, 2 };

		return new JunNurbsSurface(controlPoints, new JunDoubleMatrix(4, weights), knots, knots);
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunNurbsSurfaceTestExamples();
	}

}
